/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip.map;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.gossip.map.MapValue;

final class UpdateEntry {
    private final String key;
    private final MapValue value;

    UpdateEntry(String key, MapValue value) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public MapValue value() {
        return this.value;
    }

    public boolean isNewerThan(UpdateEntry other) {
        return other == null || other.value == null || this.value != null && this.value.isNewerThan(other.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("key", (Object)this.key()).add("value", (Object)this.value).toString();
    }

    private UpdateEntry() {
        this.key = null;
        this.value = null;
    }
}

