/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.rest.AtomixResource;
import io.atomix.rest.impl.EventLog;
import io.atomix.rest.impl.EventManager;
import io.atomix.utils.event.EventListener;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtomixResource
@Path(value="/cluster")
public class ClusterResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterResource.class);

    @GET
    @Path(value="/node")
    @Produces(value={"application/json"})
    public Response getNode(@Context ClusterMembershipService clusterMembershipService) {
        return Response.ok((Object)new NodeInfo(clusterMembershipService.getLocalMember())).build();
    }

    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json"})
    public Response getNodes(@Context ClusterMembershipService clusterMembershipService) {
        return Response.ok(clusterMembershipService.getMembers().stream().map(NodeInfo::new).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/nodes/{node}")
    @Produces(value={"application/json"})
    public Response getNodeInfo(@PathParam(value="node") String nodeId, @Context ClusterMembershipService clusterMembershipService) {
        Member member = clusterMembershipService.getMember(MemberId.from((String)nodeId));
        if (member == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new NodeInfo(member)).build();
    }

    @GET
    @Path(value="/events")
    @Produces(value={"application/json"})
    public void getEvent(@Context ClusterMembershipService clusterMembershipService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, "", l -> e -> l.addEvent(e));
        if (eventLog.open()) {
            clusterMembershipService.addListener((EventListener)eventLog.listener());
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Member)result.subject()).id(), (ClusterMembershipEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/events")
    @Produces(value={"application/json"})
    public Response addListener(@Context ClusterMembershipService clusterMembershipService, @Context EventManager events) {
        String listenerId = UUID.randomUUID().toString();
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, listenerId, l -> e -> l.addEvent(e));
        if (eventLog.open()) {
            clusterMembershipService.addListener((EventListener)eventLog.listener());
        }
        return Response.ok((Object)listenerId).build();
    }

    @GET
    @Path(value="/events/{id}")
    @Produces(value={"application/json"})
    public void getEvent(@PathParam(value="id") String listenerId, @Context ClusterMembershipService clusterMembershipService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getEventLog(ClusterResource.class, listenerId);
        if (eventLog == null) {
            response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Member)result.subject()).id(), (ClusterMembershipEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/events/{id}")
    public void removeListener(@PathParam(value="id") String listenerId, @Context ClusterMembershipService clusterMembershipService, @Context EventManager events) {
        EventLog eventLog = events.removeEventLog(ClusterResource.class, listenerId);
        if (eventLog != null && eventLog.close()) {
            clusterMembershipService.removeListener((EventListener)eventLog.listener());
        }
    }

    @GET
    @Path(value="/nodes/{node}/events")
    @Produces(value={"application/json"})
    public void getNodeEvent(@PathParam(value="node") String memberId, @Context ClusterMembershipService clusterMembershipService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, memberId, l -> e -> {
            if (((String)((Object)((Member)e.subject()).id().id())).equals(memberId)) {
                l.addEvent(e);
            }
        });
        if (eventLog.open()) {
            clusterMembershipService.addListener((EventListener)eventLog.listener());
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Member)result.subject()).id(), (ClusterMembershipEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/nodes/{node}/events")
    @Produces(value={"application/json"})
    public Response addNodeListener(@PathParam(value="node") String memberId, @Context ClusterMembershipService clusterMembershipService, @Context EventManager events) {
        String id = UUID.randomUUID().toString();
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, ClusterResource.getNodeListener(memberId, id), l -> e -> {
            if (((String)((Object)((Member)e.subject()).id().id())).equals(memberId)) {
                l.addEvent(e);
            }
        });
        if (eventLog.open()) {
            clusterMembershipService.addListener((EventListener)eventLog.listener());
        }
        return Response.ok((Object)id).build();
    }

    @GET
    @Path(value="/nodes/{node}/events/{id}")
    @Produces(value={"application/json"})
    public void getNodeEvent(@PathParam(value="node") String memberId, @PathParam(value="id") String listenerId, @Context ClusterMembershipService clusterMembershipService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getEventLog(ClusterResource.class, ClusterResource.getNodeListener(memberId, listenerId));
        if (eventLog == null) {
            response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Member)result.subject()).id(), (ClusterMembershipEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/nodes/{node}/events/{id}")
    public void removeNodeListener(@PathParam(value="node") String memberId, @PathParam(value="id") String listenerId, @Context ClusterMembershipService clusterMembershipService, @Context EventManager events) {
        EventLog eventLog = events.removeEventLog(ClusterResource.class, ClusterResource.getNodeListener(memberId, listenerId));
        if (eventLog != null && eventLog.close()) {
            clusterMembershipService.removeListener((EventListener)eventLog.listener());
        }
    }

    private static String getNodeListener(String memberId, String id) {
        return String.format("%s-%s", memberId, id);
    }

    static class NodeEvent {
        private final MemberId memberId;
        private final ClusterMembershipEvent.Type type;

        NodeEvent(MemberId memberId, ClusterMembershipEvent.Type type) {
            this.memberId = memberId;
            this.type = type;
        }

        public String getId() {
            return (String)((Object)this.memberId.id());
        }

        public ClusterMembershipEvent.Type getType() {
            return this.type;
        }
    }

    static class NodeInfo {
        private final Member member;

        NodeInfo(Member member) {
            this.member = member;
        }

        public String getId() {
            return (String)((Object)this.member.id().id());
        }

        public String getHost() {
            return this.member.address().host();
        }

        public int getPort() {
            return this.member.address().port();
        }
    }
}

