/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.collect.Sets;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.DistributedCollectionConfig;
import io.atomix.primitive.PrimitiveType;
import io.atomix.rest.resources.PrimitiveResource;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DistributedCollectionResource<P extends AsyncDistributedCollection<String>, C extends DistributedCollectionConfig<C>>
extends PrimitiveResource<P, C> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected DistributedCollectionResource(PrimitiveType type) {
        super(type);
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public void get(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        this.getPrimitive(name).whenComplete((collection, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)Sets.newHashSet((Iterator)collection.iterator().sync())));
            } else {
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/{name}/{element}")
    @Produces(value={"application/json"})
    public void add(@PathParam(value="name") String name, @PathParam(value="element") String element, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(collection -> collection.add((Object)element))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.log.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{name}/{element}")
    @Produces(value={"application/json"})
    public void contains(@PathParam(value="name") String name, @PathParam(value="element") String element, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(collection -> collection.contains((Object)element))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.log.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{name}/{element}")
    @Produces(value={"application/json"})
    public void remove(@PathParam(value="name") String name, @PathParam(value="element") String element, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(collection -> collection.remove((Object)element))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.log.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{name}/size")
    @Produces(value={"application/json"})
    public void size(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(collection -> collection.size())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                this.log.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{name}")
    public void clear(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(collection -> collection.clear())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                this.log.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

