/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.logging;

import io.atomix.utils.logging.LoggerContext;
import io.zeebe.util.ZbLogger;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class ContextualLogger
extends ZbLogger {
    private static final String SEPARATOR = " - ";
    private static final String FQCN = ContextualLogger.class.getName();
    private final LoggerContext context;

    public ContextualLogger(Logger delegate, LoggerContext context) {
        super(delegate, FQCN);
        this.context = context;
    }

    private String contextualize(String msg) {
        return this.context + SEPARATOR + msg;
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            super.trace(this.contextualize(msg));
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            super.trace(this.contextualize(format), arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            super.trace(this.contextualize(format), arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            super.trace(this.contextualize(format), arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            super.trace(this.contextualize(msg), t);
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled()) {
            super.trace(marker, this.contextualize(msg));
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled()) {
            super.trace(marker, this.contextualize(format), arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            super.trace(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled()) {
            super.trace(marker, this.contextualize(format), argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            super.trace(marker, this.contextualize(msg), t);
        }
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            super.debug(this.contextualize(msg));
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            super.debug(this.contextualize(format), arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            super.debug(this.contextualize(format), arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            super.debug(this.contextualize(format), arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(this.contextualize(msg), t);
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled()) {
            super.debug(marker, this.contextualize(msg));
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled()) {
            super.debug(marker, this.contextualize(format), arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            super.debug(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            super.debug(marker, this.contextualize(format), arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(marker, this.contextualize(msg), t);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            super.info(this.contextualize(msg));
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            super.info(this.contextualize(format), arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            super.info(this.contextualize(format), arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            super.info(this.contextualize(format), arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            super.info(this.contextualize(msg), t);
        }
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled()) {
            super.info(marker, this.contextualize(msg));
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled()) {
            super.info(marker, this.contextualize(format), arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            super.info(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            super.info(marker, this.contextualize(format), arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            super.info(marker, this.contextualize(msg), t);
        }
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            super.warn(this.contextualize(msg));
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            super.warn(this.contextualize(format), arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            super.warn(this.contextualize(format), arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            super.warn(this.contextualize(format), arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            super.warn(this.contextualize(msg), t);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled()) {
            super.warn(marker, this.contextualize(msg));
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled()) {
            super.warn(marker, this.contextualize(format), arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            super.warn(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            super.warn(marker, this.contextualize(format), arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            super.warn(marker, this.contextualize(msg), t);
        }
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            super.error(this.contextualize(msg));
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            super.error(this.contextualize(format), arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            super.error(this.contextualize(format), arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            super.error(this.contextualize(format), arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            super.error(this.contextualize(msg), t);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled()) {
            super.error(marker, this.contextualize(msg));
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled()) {
            super.error(marker, this.contextualize(format), arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            super.error(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            super.error(marker, this.contextualize(format), arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            super.error(marker, this.contextualize(msg), t);
        }
    }
}

