/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.google.common.collect.ImmutableList;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.NamespaceImpl;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackNamespace
implements Namespace {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackNamespace.class);
    private static final String DESERIALIZE_ERROR = "Serialized bytes contained header with version but deserialization failed (will fallback to FieldSerializer):\n";
    private static final String UNKNOWN_VERSION_ERROR = "Magic byte was encountered, signalling newer version of serializer, but version {} is unrecognized. Using FieldSerializer as fallback";
    private final NamespaceImpl fallback;
    private final NamespaceImpl namespace;

    FallbackNamespace(NamespaceImpl fallback, NamespaceImpl namespace) {
        this.fallback = fallback;
        this.namespace = namespace;
    }

    public FallbackNamespace(NamespaceImpl.Builder builder) {
        NamespaceImpl.Builder copy = builder.copy();
        this.fallback = builder.build();
        this.namespace = copy.name(copy.getName() + "-compatible").setCompatible(true).build();
    }

    @Override
    public byte[] serialize(Object obj) {
        return this.namespace.serialize(obj);
    }

    @Override
    public void serialize(Object obj, ByteBuffer buffer) {
        this.namespace.serialize(obj, buffer);
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        byte magicByte = bytes[1];
        byte versionByte = bytes[0];
        if (magicByte != -1) {
            return this.fallback.deserialize(bytes);
        }
        if (versionByte == 1) {
            try {
                return this.namespace.deserialize(bytes, NamespaceImpl.VERSION_HEADER.length);
            }
            catch (Exception e) {
                LOG.debug(DESERIALIZE_ERROR, (Throwable)e);
            }
        } else {
            LOG.debug(UNKNOWN_VERSION_ERROR, (Object)versionByte);
        }
        return this.fallback.deserialize(bytes);
    }

    @Override
    public <T> T deserialize(ByteBuffer buffer) {
        int position = buffer.position();
        byte version = buffer.get(position);
        byte magicByte = buffer.get(position + 1);
        if (magicByte != -1) {
            return this.fallback.deserialize(buffer);
        }
        if (version == 1) {
            try {
                buffer.position(position + NamespaceImpl.VERSION_HEADER.length);
                return this.namespace.deserialize(buffer);
            }
            catch (Exception e) {
                LOG.debug(DESERIALIZE_ERROR, (Throwable)e);
            }
        } else {
            LOG.debug(UNKNOWN_VERSION_ERROR, (Object)version);
        }
        buffer.position(position);
        return this.fallback.deserialize(buffer);
    }

    @Override
    public ImmutableList<NamespaceImpl.RegistrationBlock> getRegisteredBlocks() {
        return this.namespace.getRegisteredBlocks();
    }
}

