/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.flakytestextractor;

import io.zeebe.flakytestextractor.ExtendedReportTestCase;
import java.util.ArrayList;
import java.util.List;

public class ExtendedReportTestSuite {
    private final List<ExtendedReportTestCase> testCases = new ArrayList<ExtendedReportTestCase>();
    private int numberOfErrors;
    private int numberOfFailures;
    private int numberOfSkipped;
    private int numberOfFlakes;
    private Integer numberOfTests;
    private String name;
    private String fullClassName;
    private String packageName;
    private float timeElapsed;

    public List<ExtendedReportTestCase> getTestCases() {
        return this.testCases;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public ExtendedReportTestSuite setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
        return this;
    }

    public ExtendedReportTestSuite incrementNumberOfErrors() {
        ++this.numberOfErrors;
        return this;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public ExtendedReportTestSuite setNumberOfFailures(int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
        return this;
    }

    public ExtendedReportTestSuite incrementNumberOfFailures() {
        ++this.numberOfFailures;
        return this;
    }

    public int getNumberOfSkipped() {
        return this.numberOfSkipped;
    }

    public ExtendedReportTestSuite setNumberOfSkipped(int numberOfSkipped) {
        this.numberOfSkipped = numberOfSkipped;
        return this;
    }

    public ExtendedReportTestSuite incrementNumberOfSkipped() {
        ++this.numberOfSkipped;
        return this;
    }

    public int getNumberOfFlakes() {
        return this.numberOfFlakes;
    }

    public ExtendedReportTestSuite setNumberOfFlakes(int numberOfFlakes) {
        this.numberOfFlakes = numberOfFlakes;
        return this;
    }

    public ExtendedReportTestSuite incrementNumberOfFlakes() {
        ++this.numberOfFlakes;
        return this;
    }

    public int getNumberOfTests() {
        return this.numberOfTests == null ? this.testCases.size() : this.numberOfTests.intValue();
    }

    public ExtendedReportTestSuite setNumberOfTests(int numberOfTests) {
        this.numberOfTests = numberOfTests;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ExtendedReportTestSuite setName(String name) {
        this.name = name;
        return this;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public ExtendedReportTestSuite setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
        if (fullClassName != null) {
            int lastDotPosition = fullClassName.lastIndexOf(".");
            if (this.name == null) {
                this.name = fullClassName.substring(lastDotPosition + 1, fullClassName.length());
            }
            this.packageName = lastDotPosition == -1 ? "" : fullClassName.substring(0, lastDotPosition);
        }
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ExtendedReportTestSuite setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public float getTimeElapsed() {
        return this.timeElapsed;
    }

    public ExtendedReportTestSuite setTimeElapsed(float timeElapsed) {
        this.timeElapsed = timeElapsed;
        return this;
    }

    ExtendedReportTestSuite setTestCases(List<ExtendedReportTestCase> testCases) {
        this.testCases.clear();
        this.testCases.addAll(testCases);
        return this;
    }

    public String toString() {
        return this.fullClassName + " [" + this.getNumberOfTests() + "/" + this.getNumberOfFailures() + "/" + this.getNumberOfErrors() + "/" + this.getNumberOfSkipped() + "]";
    }
}

