/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.flakytestextractor;

import io.zeebe.flakytestextractor.ExtendedReportTestSuite;
import io.zeebe.flakytestextractor.ExtendedTestSuiteXMLParser;
import io.zeebe.flakytestextractor.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.shared.utils.io.DirectoryScanner;
import org.xml.sax.SAXException;

public class ExtendedSurefireReportParser {
    private static final String INCLUDES = "*.xml";
    private static final String EXCLUDES = "*.txt, testng-failed.xml, testng-failures.xml, testng-results.xml, failsafe-summary*.xml";
    private final Log logger;
    private final List<File> reportsDirectories;

    public ExtendedSurefireReportParser(List<File> reportsDirectories, Locale locale, Log logger) {
        this.reportsDirectories = reportsDirectories;
        this.logger = logger;
    }

    public Map<File, List<ExtendedReportTestSuite>> parseXMLReportFiles() throws ParsingException {
        ArrayList<File> xmlReportFiles = new ArrayList<File>();
        for (File reportsDirectory : this.reportsDirectories) {
            if (!reportsDirectory.exists()) continue;
            for (String xmlReportFile : ExtendedSurefireReportParser.getIncludedFiles(reportsDirectory, INCLUDES, EXCLUDES)) {
                xmlReportFiles.add(new File(reportsDirectory, xmlReportFile));
            }
        }
        HashMap<File, List<ExtendedReportTestSuite>> result = new HashMap<File, List<ExtendedReportTestSuite>>();
        ExtendedTestSuiteXMLParser parser = new ExtendedTestSuiteXMLParser(this.logger);
        for (File xmlReportFile : xmlReportFiles) {
            try {
                result.put(xmlReportFile, parser.parse(xmlReportFile.getAbsolutePath()));
            }
            catch (ParserConfigurationException e) {
                throw new ParsingException("Error setting up parser for JUnit XML report", e);
            }
            catch (SAXException e) {
                this.logger.info((CharSequence)("Skipping " + xmlReportFile.getName() + " because of parsing exception:" + e.getLocalizedMessage()));
            }
            catch (IOException e) {
                throw new ParsingException("Error reading JUnit XML report " + xmlReportFile, e);
            }
        }
        return result;
    }

    private static String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

