/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.flakytestextractor;

import io.zeebe.flakytestextractor.ExtendedReportTestSuite;
import io.zeebe.flakytestextractor.ExtendedSurefireReportParser;
import io.zeebe.flakytestextractor.ParsingException;
import io.zeebe.flakytestextractor.ReportTransformer;
import io.zeebe.flakytestextractor.XmlReporterWriter;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="extract-flaky-tests", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class FlakyTestExtractorPlugin
extends AbstractMojo {
    private static final ReportTransformer TRANSFORMER = new ReportTransformer();
    @Parameter(defaultValue="${project.build.directory}/surefire-reports", property="reportDir")
    protected File reportDir;
    @Parameter(defaultValue="true", property="failBuild")
    protected boolean failBuild = true;
    @Parameter(defaultValue="false", property="skipFlakyTestExtractor")
    protected boolean skip = false;

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"extract-flaky-tests Plugin skipped");
            return;
        }
        this.getLog().info((CharSequence)"FlakyTestExtractorPlugin - starting");
        this.getLog().info((CharSequence)("reportDir: " + this.reportDir.getAbsolutePath()));
        this.getLog().info((CharSequence)("failBuild: " + this.failBuild));
        boolean foundFlakyTests = false;
        XmlReporterWriter reportWriter = new XmlReporterWriter(this.reportDir);
        ExtendedSurefireReportParser reportsParser = new ExtendedSurefireReportParser(Collections.singletonList(this.reportDir), Locale.getDefault(), this.getLog());
        try {
            Map<File, List<ExtendedReportTestSuite>> testReports = reportsParser.parseXMLReportFiles();
            this.getLog().debug((CharSequence)("testReports.size: " + testReports.size()));
            for (File reportFile : testReports.keySet()) {
                List<ExtendedReportTestSuite> testSuites = testReports.get(reportFile);
                List<ExtendedReportTestSuite> testSuitesWithOnlyFlakyTests = testSuites.stream().map(TRANSFORMER::transform).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                this.getLog().debug((CharSequence)("testSuitesWithOnlyFlakyTests.size: " + testSuitesWithOnlyFlakyTests.size()));
                if (testSuitesWithOnlyFlakyTests.isEmpty()) continue;
                foundFlakyTests = true;
                reportWriter.writeXMLReport(reportFile, testSuitesWithOnlyFlakyTests);
            }
        }
        catch (ParsingException e) {
            this.getLog().error((Throwable)e);
        }
        if (foundFlakyTests && this.failBuild) {
            this.getLog().info((CharSequence)"FlakyTestExtractorPlugin - finished and about to fail the build");
            throw new MojoFailureException("Flaky tests encountered");
        }
        this.getLog().info((CharSequence)"FlakyTestExtractorPlugin - finished");
    }
}

