/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.flakytestextractor;

import io.zeebe.flakytestextractor.ExtendedReportTestCase;
import io.zeebe.flakytestextractor.ExtendedReportTestSuite;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.report.FileReporterUtils;
import org.apache.maven.surefire.api.report.ReporterException;
import org.apache.maven.surefire.shared.utils.xml.PrettyPrintXMLWriter;
import org.apache.maven.surefire.shared.utils.xml.XMLWriter;

public class XmlReporterWriter {
    private final File reportsDirectory;
    private final String xsdSchemaLocation = "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report-3.0.xsd";
    private final String xsdVersion = "3.0";

    public XmlReporterWriter(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public void writeXMLReport(File originalReport, List<ExtendedReportTestSuite> testSuites) {
        OutputStream outputStream = this.getOutputStream(originalReport);
        try (OutputStreamWriter fw = XmlReporterWriter.getWriter(outputStream);){
            PrettyPrintXMLWriter ppw = new PrettyPrintXMLWriter((Writer)fw);
            ppw.setEncoding(StandardCharsets.UTF_8.name());
            for (ExtendedReportTestSuite testSuite : testSuites) {
                this.createTestSuiteElement((XMLWriter)ppw, testSuite);
                this.serializeTestClassWithoutRerun(outputStream, fw, (XMLWriter)ppw, testSuite.getTestCases());
                ppw.endElement();
            }
        }
        catch (Exception e) {
            InPluginProcessDumpSingleton.getSingleton().dumpException((Throwable)e, e.getLocalizedMessage(), this.reportsDirectory);
        }
    }

    private void serializeTestClassWithoutRerun(OutputStream outputStream, OutputStreamWriter fw, XMLWriter ppw, List<ExtendedReportTestCase> testCases) {
        for (ExtendedReportTestCase testCase : testCases) {
            this.startTestElement(ppw, testCase);
            if (!testCase.isSuccessful()) {
                XmlReporterWriter.getTestProblems(fw, ppw, testCase, outputStream);
            }
            XmlReporterWriter.createOutErrElements(fw, ppw, testCase, outputStream);
            ppw.endElement();
        }
    }

    private OutputStream getOutputStream(File originalReport) {
        String originalFileName = originalReport.getName();
        String originalFilenameWithoutXML = originalFileName.substring(0, originalFileName.length() - 4);
        File reportFile = new File(this.reportsDirectory, FileReporterUtils.stripIllegalFilenameChars((String)(originalFilenameWithoutXML + "-FLAKY.xml")));
        try {
            return new BufferedOutputStream(new FileOutputStream(reportFile), 65536);
        }
        catch (Exception e) {
            throw new ReporterException("When writing report", e);
        }
    }

    private static OutputStreamWriter getWriter(OutputStream fos) {
        return new OutputStreamWriter(fos, StandardCharsets.UTF_8);
    }

    private void createTestSuiteElement(XMLWriter ppw, ExtendedReportTestSuite testSuite) {
        ppw.startElement("testsuite");
        ppw.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ppw.addAttribute("xsi:noNamespaceSchemaLocation", "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report-3.0.xsd");
        ppw.addAttribute("version", "3.0");
        String reportName = testSuite.getFullClassName();
        ppw.addAttribute("name", reportName == null ? "" : XmlReporterWriter.extraEscapeAttribute(reportName));
        ppw.addAttribute("time", String.valueOf(testSuite.getTimeElapsed()));
        ppw.addAttribute("tests", String.valueOf(testSuite.getNumberOfTests()));
        ppw.addAttribute("errors", String.valueOf(testSuite.getNumberOfErrors()));
        ppw.addAttribute("skipped", String.valueOf(testSuite.getNumberOfSkipped()));
        ppw.addAttribute("failures", String.valueOf(testSuite.getNumberOfFailures()));
    }

    private void startTestElement(XMLWriter ppw, ExtendedReportTestCase testCase) {
        ppw.startElement("testcase");
        String name = testCase.getName();
        ppw.addAttribute("name", name == null ? "" : XmlReporterWriter.extraEscapeAttribute(name));
        String className = testCase.getFullClassName();
        if (className != null) {
            ppw.addAttribute("classname", XmlReporterWriter.extraEscapeAttribute(className));
        }
        ppw.addAttribute("time", String.valueOf(testCase.getTime()));
    }

    private static void getTestProblems(OutputStreamWriter outputStreamWriter, XMLWriter ppw, ExtendedReportTestCase testCase, OutputStream fw) {
        ppw.startElement("failure");
        XmlReporterWriter.addAttributeIfNotEmpty(ppw, "message", testCase.getFailureMessage());
        XmlReporterWriter.addAttributeIfNotEmpty(ppw, "type", testCase.getFailureType());
        String stackTrace = testCase.getFailureDetail();
        if (stackTrace != null) {
            XmlReporterWriter.extraEscapeElementValue(stackTrace, outputStreamWriter, ppw, fw);
        }
        ppw.endElement();
    }

    private static void addAttributeIfNotEmpty(XMLWriter ppw, String attributeName, String valueToWrite) {
        if (valueToWrite != null && !valueToWrite.isEmpty()) {
            ppw.addAttribute(attributeName, XmlReporterWriter.extraEscapeAttribute(valueToWrite));
        }
    }

    private static void createOutErrElements(OutputStreamWriter outputStreamWriter, XMLWriter ppw, ExtendedReportTestCase testCase, OutputStream fw) {
        EncodingOutputStream eos = new EncodingOutputStream(fw);
        XmlReporterWriter.addOutputStreamElement(outputStreamWriter, eos, ppw, testCase.getSystemOut(), "system-out");
        XmlReporterWriter.addOutputStreamElement(outputStreamWriter, eos, ppw, testCase.getSystemError(), "system-err");
    }

    private static void addOutputStreamElement(OutputStreamWriter outputStreamWriter, EncodingOutputStream eos, XMLWriter xmlWriter, String content, String name) {
        if (content != null && !content.isEmpty()) {
            xmlWriter.startElement(name);
            try {
                xmlWriter.writeText("");
                outputStreamWriter.flush();
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_START_BYTES);
                eos.write(content.getBytes(StandardCharsets.UTF_8));
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_END_BYTES);
                eos.flush();
            }
            catch (IOException e) {
                throw new ReporterException("When writing xml report stdout/stderr", (Exception)e);
            }
            xmlWriter.endElement();
        }
    }

    private static String extraEscapeAttribute(String message) {
        return XmlReporterWriter.containsEscapesIllegalXml10(message) ? XmlReporterWriter.escapeXml(message, true) : message;
    }

    private static void extraEscapeElementValue(String message, OutputStreamWriter outputStreamWriter, XMLWriter xmlWriter, OutputStream fw) {
        if (XmlReporterWriter.containsEscapesIllegalXml10(message)) {
            xmlWriter.writeText(XmlReporterWriter.escapeXml(message, false));
        } else {
            try {
                EncodingOutputStream eos = new EncodingOutputStream(fw);
                xmlWriter.writeText("");
                outputStreamWriter.flush();
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_START_BYTES);
                eos.write(message.getBytes(StandardCharsets.UTF_8));
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_END_BYTES);
                eos.flush();
            }
            catch (IOException e) {
                throw new ReporterException("When writing xml element", (Exception)e);
            }
        }
    }

    private static boolean containsEscapesIllegalXml10(String message) {
        int size = message.length();
        for (int i = 0; i < size; ++i) {
            if (!XmlReporterWriter.isIllegalEscape(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isIllegalEscape(char c) {
        return XmlReporterWriter.isIllegalEscape((int)c);
    }

    private static boolean isIllegalEscape(int c) {
        return c >= 0 && c < 32 && c != 10 && c != 13 && c != 9;
    }

    private static String escapeXml(String text, boolean attribute) {
        StringBuilder sb = new StringBuilder(text.length() * 2);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (XmlReporterWriter.isIllegalEscape(c)) {
                sb.append(attribute ? "&#" : "&amp#").append((int)c).append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final class ByteConstantsHolder {
        private static final byte[] CDATA_START_BYTES = "<![CDATA[".getBytes(StandardCharsets.UTF_8);
        private static final byte[] CDATA_END_BYTES = "]]>".getBytes(StandardCharsets.UTF_8);
        private static final byte[] CDATA_ESCAPE_STRING_BYTES = "]]><![CDATA[>".getBytes(StandardCharsets.UTF_8);
        private static final byte[] AMP_BYTES = "&amp#".getBytes(StandardCharsets.UTF_8);

        private ByteConstantsHolder() {
        }
    }

    private static final class EncodingOutputStream
    extends FilterOutputStream {
        private int c1;
        private int c2;

        EncodingOutputStream(OutputStream out) {
            super(out);
        }

        OutputStream getUnderlying() {
            return this.out;
        }

        private boolean isCdataEndBlock(int c) {
            return this.c1 == 93 && this.c2 == 93 && c == 62;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isCdataEndBlock(b)) {
                this.out.write(ByteConstantsHolder.CDATA_ESCAPE_STRING_BYTES);
            } else if (XmlReporterWriter.isIllegalEscape(b)) {
                this.out.write(ByteConstantsHolder.AMP_BYTES);
                this.out.write(String.valueOf(b).getBytes(StandardCharsets.UTF_8));
                this.out.write(59);
            } else {
                this.out.write(b);
            }
            this.c1 = this.c2;
            this.c2 = b;
        }
    }
}

