/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.hazelcast.exporter;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.ringbuffer.Ringbuffer;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.protocol.record.Record;
import io.zeebe.exporter.proto.RecordTransformer;
import io.zeebe.exporter.proto.Schema;
import io.zeebe.hazelcast.exporter.ExporterConfiguration;
import io.zeebe.hazelcast.exporter.HazelcastRecordFilter;
import java.util.function.Function;
import org.slf4j.Logger;

public class HazelcastExporter
implements Exporter {
    private ExporterConfiguration config;
    private Logger logger;
    private Controller controller;
    private HazelcastInstance hazelcast;
    private Ringbuffer<byte[]> ringbuffer;
    private Function<Record, byte[]> recordTransformer;

    public void configure(Context context) {
        this.logger = context.getLogger();
        this.config = (ExporterConfiguration)context.getConfiguration().instantiate(ExporterConfiguration.class);
        this.logger.debug("Starting exporter with configuration: {}", (Object)this.config);
        HazelcastRecordFilter filter = new HazelcastRecordFilter(this.config);
        context.setFilter((Context.RecordFilter)filter);
        this.configureFormat();
    }

    private void configureFormat() {
        String format = this.config.getFormat();
        if (format.equalsIgnoreCase("protobuf")) {
            this.recordTransformer = this::recordToProtobuf;
        } else if (format.equalsIgnoreCase("json")) {
            this.recordTransformer = this::recordToJson;
        } else {
            throw new IllegalArgumentException(String.format("Expected the parameter 'format' to be one fo 'protobuf' or 'json' but was '%s'", format));
        }
    }

    public void open(Controller controller) {
        this.controller = controller;
        this.hazelcast = this.config.getRemoteAddress().map(this::connectToHazelcast).orElseGet(this::createHazelcastInstance);
        this.ringbuffer = this.hazelcast.getRingbuffer(this.config.getName());
        if (this.ringbuffer == null) {
            throw new IllegalStateException(String.format("Failed to open ring-buffer with name '%s'", this.config.getName()));
        }
        this.logger.info("Export records to ring-buffer with name '{}' [head: {}, tail: {}, size: {}, capacity: {}]", new Object[]{this.ringbuffer.getName(), this.ringbuffer.headSequence(), this.ringbuffer.tailSequence(), this.ringbuffer.size(), this.ringbuffer.capacity()});
    }

    private HazelcastInstance createHazelcastInstance() {
        int port = this.config.getPort();
        Config hzConfig = new Config();
        hzConfig.getNetworkConfig().setPort(port);
        hzConfig.setProperty("hazelcast.logging.type", "slf4j");
        RingbufferConfig ringbufferConfig = new RingbufferConfig(this.config.getName());
        if (this.config.getCapacity() > 0) {
            ringbufferConfig.setCapacity(this.config.getCapacity());
        }
        if (this.config.getTimeToLiveInSeconds() > 0) {
            ringbufferConfig.setTimeToLiveSeconds(this.config.getTimeToLiveInSeconds());
        }
        hzConfig.addRingBufferConfig(ringbufferConfig);
        this.logger.info("Creating new in-memory Hazelcast instance [port: {}]", (Object)port);
        return Hazelcast.newHazelcastInstance((Config)hzConfig);
    }

    private HazelcastInstance connectToHazelcast(String remoteAddress) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.logging.type", "slf4j");
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        networkConfig.addAddress(new String[]{remoteAddress});
        this.logger.info("Connecting to remote Hazelcast instance [address: {}]", (Object)remoteAddress);
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    public void close() {
        this.hazelcast.shutdown();
    }

    public void export(Record record) {
        if (this.ringbuffer != null) {
            byte[] transformedRecord = this.recordTransformer.apply(record);
            long sequenceNumber = this.ringbuffer.add((Object)transformedRecord);
            this.logger.trace("Added a record to the ring-buffer [record-position: {}, ring-buffer sequence-number: {}]", (Object)record.getPosition(), (Object)sequenceNumber);
        }
        this.controller.updateLastExportedRecordPosition(record.getPosition());
    }

    private byte[] recordToProtobuf(Record record) {
        Schema.Record dto = RecordTransformer.toGenericRecord((Record)record);
        return dto.toByteArray();
    }

    private byte[] recordToJson(Record record) {
        String json = record.toJson();
        return json.getBytes();
    }
}

