/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.protocol.codec.JetExistsDistributedObjectCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobAndSqlSummaryListCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSummaryListCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.ClientJobProxy;
import com.hazelcast.jet.impl.JobAndSqlSummary;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class JetClientInstanceImpl
extends AbstractJetInstance<UUID> {
    private final HazelcastClientInstanceImpl client;
    private final SerializationService serializationService;

    public JetClientInstanceImpl(HazelcastClientInstanceImpl hazelcastInstance) {
        super(hazelcastInstance);
        this.client = hazelcastInstance;
        this.serializationService = this.client.getSerializationService();
        ExceptionUtil.registerJetExceptions(hazelcastInstance.getClientExceptionFactory());
    }

    @Override
    public UUID getMasterId() {
        return this.client.getClientClusterService().getMasterMember().getUuid();
    }

    @Override
    public Map<UUID, GetJobIdsOperation.GetJobIdsResult> getJobsInt(String onlyName, Long onlyJobId) {
        return (Map)this.invokeRequestOnAnyMemberAndDecodeResponse(JetGetJobIdsCodec.encodeRequest(onlyName, onlyJobId == null ? Long.MIN_VALUE : onlyJobId), resp -> {
            Data responseSerialized = JetGetJobIdsCodec.decodeResponse((ClientMessage)resp).response;
            return this.serializationService.toObject(responseSerialized);
        });
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        throw new UnsupportedOperationException("Jet Configuration is not available on the client");
    }

    @Nonnull
    public List<JobSummary> getJobSummaryList() {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobSummaryListCodec.encodeRequest(), JetGetJobSummaryListCodec::decodeResponse);
    }

    @Nonnull
    public List<JobAndSqlSummary> getJobAndSqlSummaryList() {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobAndSqlSummaryListCodec.encodeRequest(), JetGetJobAndSqlSummaryListCodec::decodeResponse);
    }

    @Nonnull
    public HazelcastClientInstanceImpl getHazelcastClient() {
        return this.client;
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return (Boolean)this.invokeRequestOnAnyMemberAndDecodeResponse(JetExistsDistributedObjectCodec.encodeRequest(serviceName, objectName), JetExistsDistributedObjectCodec::decodeResponse);
    }

    public List<DistributedObjectInfo> getDistributedObjects() {
        return (List)this.invokeRequestOnAnyMemberAndDecodeResponse(ClientGetDistributedObjectsCodec.encodeRequest(), ClientGetDistributedObjectsCodec::decodeResponse);
    }

    @Override
    public Job newJobProxy(long jobId, UUID lightJobCoordinator) {
        return new ClientJobProxy(this.client, jobId, lightJobCoordinator);
    }

    @Override
    public Job newJobProxy(long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config) {
        return new ClientJobProxy(this.client, jobId, isLightJob, jobDefinition, config);
    }

    @Override
    public ILogger getLogger() {
        return this.client.getLoggingService().getLogger(this.getClass());
    }

    private <S> S invokeRequestOnMasterAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        return this.invokeRequestAndDecodeResponse(this.getMasterId(), request, decoder);
    }

    private <S> S invokeRequestOnAnyMemberAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        return this.invokeRequestAndDecodeResponse(null, request, decoder);
    }

    private <S> S invokeRequestAndDecodeResponse(UUID uuid, ClientMessage request, Function<ClientMessage, Object> decoder) {
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, uuid);
        try {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            return (S)this.serializationService.toObject(decoder.apply(response));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

