/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.util.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ConcurrentInitialSetCache<K, V> {
    final Map<K, V> cache;
    private final int capacity;

    public ConcurrentInitialSetCache(int capacity) {
        Preconditions.checkPositive("capacity", capacity);
        this.capacity = capacity;
        this.cache = new ConcurrentHashMap(capacity);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> valueFunction) {
        V value = this.cache.get(key);
        if (value == null) {
            value = this.cache.size() < this.capacity ? this.cache.computeIfAbsent((K)key, (Function<? super K, ? extends V>)valueFunction) : valueFunction.apply(key);
        }
        return value;
    }
}

