/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.hazelcast.exporter;

import java.util.Optional;

public class ExporterConfiguration {
    private static final String ENV_PREFIX = "ZEEBE_HAZELCAST_";
    private int port = 5701;
    private String clusterName = "dev";
    private String name = "zeebe";
    private int capacity = -1;
    private int timeToLiveInSeconds = 0;
    private String format = "protobuf";
    private String enabledValueTypes = "";
    private String enabledRecordTypes = "";
    private String remoteAddress;
    private String remoteConnectionTimeout = "PT30S";

    public int getPort() {
        return this.getEnv("PORT").map(Integer::parseInt).orElse(this.port);
    }

    public String getName() {
        return this.getEnv("NAME").orElse(this.name);
    }

    public int getCapacity() {
        return this.getEnv("CAPACITY").map(Integer::parseInt).orElse(this.capacity);
    }

    public int getTimeToLiveInSeconds() {
        return this.getEnv("TIME_TO_LIVE_IN_SECONDS").map(Integer::parseInt).orElse(this.timeToLiveInSeconds);
    }

    public String getFormat() {
        return this.getEnv("FORMAT").orElse(this.format);
    }

    public String getEnabledValueTypes() {
        return this.getEnv("ENABLED_VALUE_TYPES").orElse(this.enabledValueTypes);
    }

    public String getEnabledRecordTypes() {
        return this.getEnv("ENABLED_RECORD_TYPES").orElse(this.enabledRecordTypes);
    }

    public Optional<String> getRemoteAddress() {
        return this.getEnv("REMOTE_ADDRESS").or(() -> Optional.ofNullable(this.remoteAddress)).filter(remoteAddress -> !remoteAddress.isEmpty());
    }

    public String getClusterName() {
        return this.getEnv("CLUSTER_NAME").orElse(this.clusterName);
    }

    public String getRemoteConnectionTimeout() {
        return this.getEnv("REMOTE_CONNECTION_TIMEOUT").orElse(this.remoteConnectionTimeout);
    }

    private Optional<String> getEnv(String name) {
        return Optional.ofNullable(System.getenv(ENV_PREFIX + name));
    }

    public String toString() {
        return "[port=" + this.port + ", remoteAddress=" + this.remoteAddress + ", name=" + this.name + ", clusterName=" + this.clusterName + ", enabledValueTypes=" + this.enabledValueTypes + ", enabledRecordTypes=" + this.enabledRecordTypes + ", capacity=" + this.capacity + ", timeToLiveInSeconds=" + this.timeToLiveInSeconds + ", format=" + this.format + ", remoteConnectionTimeout=" + this.remoteConnectionTimeout + "]";
    }
}

