/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.hazelcast.exporter;

import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.zeebe.hazelcast.exporter.ExporterConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class HazelcastRecordFilter
implements Context.RecordFilter {
    private final List<RecordType> enabledRecordTypes;
    private final List<ValueType> enabledValueTypes;

    public HazelcastRecordFilter(ExporterConfiguration config) {
        List<String> enabledRecordTypeList = this.parseAsList(config.getEnabledRecordTypes());
        this.enabledRecordTypes = Arrays.stream(RecordType.values()).filter(recordType -> enabledRecordTypeList.isEmpty() || enabledRecordTypeList.contains(recordType.name())).collect(Collectors.toList());
        List<String> enabledValueTypeList = this.parseAsList(config.getEnabledValueTypes());
        this.enabledValueTypes = Arrays.stream(ValueType.values()).filter(valueType -> enabledValueTypeList.isEmpty() || enabledValueTypeList.contains(valueType.name())).collect(Collectors.toList());
    }

    private List<String> parseAsList(String list) {
        return Arrays.stream(list.split(",")).map(String::trim).filter(item -> !item.isEmpty()).map(String::toUpperCase).collect(Collectors.toList());
    }

    public boolean acceptType(RecordType recordType) {
        return this.enabledRecordTypes.contains(recordType);
    }

    public boolean acceptValue(ValueType valueType) {
        return this.enabledValueTypes.contains(valueType);
    }
}

