/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.ServerInputSubscription;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.impl.ServerReceiveHandler;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import java.util.concurrent.CompletableFuture;

public class BufferingServerTransport
extends ServerTransport {
    protected final Dispatcher receiveBuffer;

    public BufferingServerTransport(ActorContext transportActorContext, TransportContext transportContext) {
        super(transportActorContext, transportContext);
        this.receiveBuffer = transportContext.getReceiveBuffer();
    }

    public CompletableFuture<ServerInputSubscription> openSubscription(String subscriptionName, ServerMessageHandler messageHandler, ServerRequestHandler requestHandler) {
        return this.receiveBuffer.openSubscriptionAsync(subscriptionName).thenApply(s -> new ServerInputSubscriptionImpl(this.output, (Subscription)s, this.transportContext.getRemoteAddressList(), messageHandler, requestHandler));
    }

    protected static class ServerInputSubscriptionImpl
    implements ServerInputSubscription {
        protected final Subscription subscription;
        protected final FragmentHandler fragmentHandler;

        public ServerInputSubscriptionImpl(ServerOutput output, Subscription subscription, RemoteAddressList addressList, ServerMessageHandler messageHandler, ServerRequestHandler requestHandler) {
            this.subscription = subscription;
            this.fragmentHandler = new ServerReceiveHandler(output, addressList, messageHandler, requestHandler, null);
        }

        @Override
        public int poll() {
            return this.poll(Integer.MAX_VALUE);
        }

        @Override
        public int poll(int maxCount) {
            return this.subscription.poll(this.fragmentHandler, maxCount);
        }
    }
}

