/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.transport.ClientInputMessageSubscription;
import io.zeebe.transport.ClientMessageHandler;
import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.TransportListener;
import io.zeebe.transport.impl.ClientRequestPool;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;

public class ClientTransport
implements AutoCloseable {
    private final ClientOutput output;
    private final ClientRequestPool requestPool;
    private final RemoteAddressList remoteAddressList;
    private final ActorContext transportActorContext;
    private final Dispatcher receiveBuffer;
    private final TransportContext transportContext;

    public ClientTransport(ActorContext transportActorContext, TransportContext transportContext) {
        this.transportActorContext = transportActorContext;
        this.transportContext = transportContext;
        this.output = transportContext.getClientOutput();
        this.requestPool = transportContext.getClientRequestPool();
        this.remoteAddressList = transportContext.getRemoteAddressList();
        this.receiveBuffer = transportContext.getReceiveBuffer();
    }

    public ClientOutput getOutput() {
        return this.output;
    }

    public RemoteAddress registerRemoteAddress(SocketAddress addr) {
        return this.remoteAddressList.register(addr);
    }

    public void deactivateRemoteAddress(RemoteAddress remote) {
        this.remoteAddressList.deactivate(remote);
    }

    public void retireRemoteAddress(RemoteAddress remote) {
        this.remoteAddressList.retire(remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteAddress registerRemoteAndAwaitChannel(final SocketAddress addr) {
        RemoteAddress remoteAddress = this.getRemoteAddress(addr);
        if (remoteAddress != null) {
            return remoteAddress;
        }
        final Object monitor = new Object();
        TransportListener listener = new TransportListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionEstablished(RemoteAddress remoteAddress) {
                Object object = monitor;
                synchronized (object) {
                    if (remoteAddress.getAddress().equals(addr)) {
                        monitor.notifyAll();
                        ClientTransport.this.removeChannelListener(this);
                    }
                }
            }

            @Override
            public void onConnectionClosed(RemoteAddress remoteAddress) {
            }
        };
        this.transportActorContext.registerListener(listener).join();
        Object object = monitor;
        synchronized (object) {
            RemoteAddress registeredAddress = this.registerRemoteAddress(addr);
            try {
                monitor.wait(Duration.ofSeconds(10L).toMillis());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return registeredAddress;
        }
    }

    public RemoteAddress getRemoteAddress(SocketAddress addr) {
        return this.remoteAddressList.getByAddress(addr);
    }

    public RemoteAddress getRemoteAddress(int streamId) {
        return this.remoteAddressList.getByStreamId(streamId);
    }

    public CompletableFuture<ClientInputMessageSubscription> openSubscription(String subscriptionName, ClientMessageHandler messageHandler) {
        if (this.receiveBuffer == null) {
            throw new RuntimeException("Cannot throw exception. No receive buffer in use");
        }
        return this.receiveBuffer.openSubscriptionAsync(subscriptionName).thenApply(s -> new ClientInputMessageSubscriptionImpl((Subscription)s, messageHandler, this.output, this.remoteAddressList));
    }

    public CompletableFuture<Void> registerChannelListener(TransportListener channelListener) {
        return this.transportActorContext.registerListener(channelListener);
    }

    public void removeChannelListener(TransportListener listener) {
        this.transportActorContext.removeListener(listener);
    }

    public CompletableFuture<Void> closeAsync() {
        return this.transportActorContext.onClose().whenComplete((v, t) -> {
            this.requestPool.close();
            this.transportContext.getActorReferences().forEach(r -> r.close());
        });
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    public void interruptAllChannels() {
        this.transportActorContext.interruptAllChannels();
    }

    public CompletableFuture<Void> closeAllChannels() {
        return this.transportActorContext.closeAllOpenChannels();
    }

    public long getChannelKeepAlivePeriod() {
        return this.transportContext.getChannelKeepAlivePeriod();
    }

    protected static class ClientInputMessageSubscriptionImpl
    implements ClientInputMessageSubscription {
        protected final Subscription subscription;
        protected final FragmentHandler messageHandler;

        public ClientInputMessageSubscriptionImpl(Subscription subscription, final ClientMessageHandler messageHandler, final ClientOutput output, final RemoteAddressList remoteAddresses) {
            this.subscription = subscription;
            this.messageHandler = new FragmentHandler(){

                public int onFragment(DirectBuffer buffer, int offset, int length, int streamId, boolean isMarkedFailed) {
                    RemoteAddress remoteAddress = remoteAddresses.getByStreamId(streamId);
                    boolean success = messageHandler.onMessage(output, remoteAddress, buffer, offset, length);
                    return success ? 0 : 1;
                }
            };
        }

        @Override
        public int poll() {
            return this.subscription.peekAndConsume(this.messageHandler, Integer.MAX_VALUE);
        }
    }
}

