/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.transport.ClientInputListener;
import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.impl.ClientOutputImpl;
import io.zeebe.transport.impl.ClientReceiveHandler;
import io.zeebe.transport.impl.ClientRequestPool;
import io.zeebe.transport.impl.ClientSendFailureHandler;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.RequestManager;
import io.zeebe.transport.impl.TransportChannelFactory;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ClientActorContext;
import io.zeebe.transport.impl.actor.ClientConductor;
import io.zeebe.transport.impl.actor.Receiver;
import io.zeebe.transport.impl.actor.Sender;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorScheduler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ClientTransportBuilder {
    public static final String SEND_BUFFER_SUBSCRIPTION_NAME = "sender";
    protected static final long DEFAULT_CHANNEL_KEEP_ALIVE_PERIOD = 5000L;
    protected static final long DEFAULT_CHANNEL_CONNECT_TIMEOUT = 500L;
    private int requestPoolSize = 64;
    private int messageMaxLength = 524288;
    protected long keepAlivePeriod = 5000L;
    protected Dispatcher receiveBuffer;
    private Dispatcher sendBuffer;
    private ActorScheduler scheduler;
    protected List<ClientInputListener> listeners;
    protected TransportChannelFactory channelFactory;
    protected boolean enableManagedRequests = false;
    protected long defaultRequestRetryTimeout = Duration.ofSeconds(15L).toMillis();

    public ClientTransportBuilder scheduler(ActorScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ClientTransportBuilder messageReceiveBuffer(Dispatcher receiveBuffer) {
        this.receiveBuffer = receiveBuffer;
        return this;
    }

    public ClientTransportBuilder inputListener(ClientInputListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ClientInputListener>();
        }
        this.listeners.add(listener);
        return this;
    }

    public ClientTransportBuilder sendBuffer(Dispatcher sendBuffer) {
        this.sendBuffer = sendBuffer;
        return this;
    }

    public ClientTransportBuilder messageMaxLength(int messageMaxLength) {
        this.messageMaxLength = messageMaxLength;
        return this;
    }

    public ClientTransportBuilder requestPoolSize(int requestPoolSize) {
        this.requestPoolSize = requestPoolSize;
        return this;
    }

    public ClientTransportBuilder keepAlivePeriod(long keepAlivePeriod) {
        this.keepAlivePeriod = keepAlivePeriod;
        return this;
    }

    public ClientTransportBuilder channelFactory(TransportChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public ClientTransportBuilder enableManagedRequests() {
        this.enableManagedRequests = true;
        return this;
    }

    public ClientTransportBuilder defaultRequestRetryTimeout(Duration duration) {
        this.defaultRequestRetryTimeout = duration.toMillis();
        return this;
    }

    public ClientTransport build() {
        this.validate();
        ClientRequestPool clientRequestPool = new ClientRequestPool(this.requestPoolSize, this.sendBuffer);
        RequestManager requestManager = this.enableManagedRequests ? new RequestManager(clientRequestPool) : null;
        ClientOutputImpl output = new ClientOutputImpl(this.sendBuffer, clientRequestPool, requestManager, this.defaultRequestRetryTimeout);
        RemoteAddressListImpl remoteAddressList = new RemoteAddressListImpl();
        TransportContext transportContext = this.buildTransportContext(output, clientRequestPool, requestManager, remoteAddressList, new ClientReceiveHandler(clientRequestPool, this.receiveBuffer, this.listeners), this.receiveBuffer);
        return this.build(transportContext);
    }

    protected TransportContext buildTransportContext(ClientOutput output, ClientRequestPool clientRequestPool, RequestManager requestManager, RemoteAddressListImpl addressList, FragmentHandler receiveHandler, Dispatcher receiveBuffer) {
        TransportContext context = new TransportContext();
        context.setClientOutput(output);
        context.setReceiveBuffer(receiveBuffer);
        context.setMessageMaxLength(this.messageMaxLength);
        context.setClientRequestPool(clientRequestPool);
        context.setRequestManager(requestManager);
        context.setRemoteAddressList(addressList);
        context.setReceiveHandler(receiveHandler);
        context.setSenderSubscription(this.sendBuffer.getSubscriptionByName(SEND_BUFFER_SUBSCRIPTION_NAME));
        context.setSendFailureHandler(new ClientSendFailureHandler(clientRequestPool));
        context.setChannelKeepAlivePeriod(this.keepAlivePeriod);
        if (this.channelFactory != null) {
            context.setChannelFactory(this.channelFactory);
        }
        return context;
    }

    protected ClientTransport build(TransportContext context) {
        ClientActorContext actorContext = new ClientActorContext();
        ClientConductor conductor = new ClientConductor(actorContext, context);
        Sender sender = new Sender(actorContext, context);
        Receiver receiver = new Receiver(actorContext, context);
        ArrayList<ActorReference> actorReferences = new ArrayList<ActorReference>();
        actorReferences.add(this.scheduler.schedule((Actor)conductor));
        actorReferences.add(this.scheduler.schedule((Actor)sender));
        actorReferences.add(this.scheduler.schedule((Actor)receiver));
        RequestManager requestManager = context.getRequestManager();
        if (requestManager != null) {
            actorReferences.add(this.scheduler.schedule((Actor)requestManager));
        }
        context.setActorReferences(actorReferences);
        return new ClientTransport(actorContext, context);
    }

    private void validate() {
        Objects.requireNonNull(this.scheduler, "Scheduler must be provided");
        Objects.requireNonNull(this.sendBuffer, "Send buffer must be provieded");
    }
}

