/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.transport.ClientRequest;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.state.SimpleStateMachineContext;
import io.zeebe.util.state.State;
import io.zeebe.util.state.StateMachine;
import io.zeebe.util.state.StateMachineAgent;
import io.zeebe.util.state.StateMachineCommand;
import io.zeebe.util.state.TransitionState;
import io.zeebe.util.state.WaitState;
import org.agrona.DirectBuffer;

public class RequestResponseController {
    private static final int TRANSITION_DEFAULT = 0;
    private static final int TRANSITION_OPEN = 1;
    private static final int TRANSITION_FAILED = 2;
    private static final int TRANSITION_CLOSE = 3;
    private static final StateMachineCommand<RequestResponseContext> CLOSE_STATE_MACHINE_COMMAND = c -> {
        boolean closed = c.tryTake(3);
        if (!closed) {
            throw new IllegalStateException("Cannot close state machine.");
        }
    };
    private final WaitState<RequestResponseContext> closedState = c -> {};
    private final WaitState<RequestResponseContext> responseAvailableState = c -> {};
    private final WaitState<RequestResponseContext> failedState = c -> {};
    private final ClosingState closingState = new ClosingState();
    private final SendRequestState sendRequestState = new SendRequestState();
    private final PollResponseState pollResponseState = new PollResponseState();
    private RequestResponseContext requestResponseContext;
    private final StateMachineAgent<RequestResponseContext> requestStateMachine = new StateMachineAgent(StateMachine.builder(s -> {
        this.requestResponseContext = new RequestResponseContext((StateMachine<?>)s, timeout, transport);
        return this.requestResponseContext;
    }).initialState(this.closedState).from(this.closedState).take(1).to((State)this.sendRequestState).from(this.closedState).take(3).to(this.closedState).from((State)this.sendRequestState).take(0).to((State)this.pollResponseState).from((State)this.sendRequestState).take(2).to(this.failedState).from((State)this.sendRequestState).take(3).to((State)this.closingState).from((State)this.pollResponseState).take(0).to(this.responseAvailableState).from((State)this.pollResponseState).take(2).to(this.failedState).from((State)this.pollResponseState).take(3).to((State)this.closingState).from(this.responseAvailableState).take(3).to((State)this.closingState).from(this.failedState).take(3).to((State)this.closingState).from((State)this.closingState).take(0).to(this.closedState).from((State)this.closingState).take(3).to((State)this.closingState).build());

    public RequestResponseController(ClientTransport transport) {
        this(transport, -1);
    }

    public RequestResponseController(ClientTransport transport, int timeout) {
    }

    public void open(SocketAddress receiver, BufferWriter requestWriter, BufferReader responseReader) {
        if (!this.isClosed()) {
            throw new IllegalStateException("Cannot open state machine, has not been closed.");
        }
        this.requestResponseContext.receiver.wrap(receiver);
        this.requestResponseContext.requestWriter = requestWriter;
        this.requestResponseContext.responseReader = responseReader;
        this.requestResponseContext.take(1);
    }

    public void close() {
        this.requestStateMachine.addCommand(CLOSE_STATE_MACHINE_COMMAND);
    }

    public int doWork() {
        return this.requestStateMachine.doWork();
    }

    public boolean isFailed() {
        return this.requestStateMachine.getCurrentState() == this.failedState;
    }

    public Exception getFailure() {
        return this.requestResponseContext.failure;
    }

    public boolean isResponseAvailable() {
        return this.requestStateMachine.getCurrentState() == this.responseAvailableState;
    }

    public boolean isClosed() {
        return this.requestStateMachine.getCurrentState() == this.closedState;
    }

    public DirectBuffer getResponseBuffer() {
        if (this.requestResponseContext.response == null) {
            throw new RuntimeException("no response available");
        }
        return this.requestResponseContext.response;
    }

    public int getResponseLength() {
        if (this.requestResponseContext.response == null) {
            throw new RuntimeException("no response available");
        }
        return this.requestResponseContext.response.capacity();
    }

    public RemoteAddress getReceiverRemote() {
        return this.requestResponseContext.receiverRemote;
    }

    static class ClosingState
    implements TransitionState<RequestResponseContext> {
        ClosingState() {
        }

        public void work(RequestResponseContext context) throws Exception {
            ClientRequest request = context.request;
            if (request != null) {
                request.close();
            }
            context.response = null;
            context.request = null;
            context.requestWriter = null;
            context.responseReader = null;
            context.receiver.reset();
            context.take(0);
        }
    }

    static class PollResponseState
    implements State<RequestResponseContext> {
        PollResponseState() {
        }

        public int doWork(RequestResponseContext context) throws Exception {
            int workcount = 0;
            ClientRequest request = context.request;
            if (request.isDone()) {
                ++workcount;
                context.response = (DirectBuffer)request.get();
                if (context.responseReader != null) {
                    context.responseReader.wrap(context.response, 0, context.response.capacity());
                }
                context.take(0);
            }
            return workcount;
        }

        public void onFailure(RequestResponseContext context, Exception e) {
            context.failure = e;
            context.take(2);
        }
    }

    static class SendRequestState
    implements TransitionState<RequestResponseContext> {
        SendRequestState() {
        }

        public void work(RequestResponseContext context) throws Exception {
            ClientTransport transport = context.transport;
            context.receiverRemote = transport.registerRemoteAddress(context.receiver);
            ClientRequest request = transport.getOutput().sendRequestWithRetry(context.receiverRemote, context.requestWriter);
            if (request != null) {
                context.request = request;
                context.take(0);
            }
        }

        public void onFailure(RequestResponseContext context, Exception e) {
            context.failure = e;
            context.take(2);
        }
    }

    static class RequestResponseContext
    extends SimpleStateMachineContext {
        final SocketAddress receiver = new SocketAddress();
        final int timeout;
        final ClientTransport transport;
        BufferWriter requestWriter;
        BufferReader responseReader;
        DirectBuffer response;
        Exception failure;
        ClientRequest request;
        RemoteAddress receiverRemote;

        RequestResponseContext(StateMachine<?> stateMachine, int timeout, ClientTransport transport) {
            super(stateMachine);
            this.timeout = timeout;
            this.transport = transport;
        }

        public ClientRequest getRequest() {
            return this.request;
        }

        public void setRequest(ClientRequest request) {
            this.request = request;
        }
    }
}

