/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.TransportListener;
import io.zeebe.transport.impl.ServerSocketBinding;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import java.util.concurrent.CompletableFuture;

public class ServerTransport
implements AutoCloseable {
    protected final ServerOutput output;
    protected final ActorContext transportActorContext;
    protected final TransportContext transportContext;
    protected final ServerSocketBinding serverSocketBinding;

    public ServerTransport(ActorContext transportActorContext, TransportContext transportContext) {
        this.transportActorContext = transportActorContext;
        this.transportContext = transportContext;
        this.output = transportContext.getServerOutput();
        this.serverSocketBinding = transportContext.getServerSocketBinding();
    }

    public ServerOutput getOutput() {
        return this.output;
    }

    public CompletableFuture<Void> registerChannelListener(TransportListener channelListener) {
        return this.transportActorContext.registerListener(channelListener);
    }

    public void removeChannelListener(TransportListener listener) {
        this.transportActorContext.removeListener(listener);
    }

    public CompletableFuture<Void> closeAsync() {
        return this.transportActorContext.onClose().whenComplete((v, t) -> {
            this.serverSocketBinding.close();
            this.transportContext.getActorReferences().forEach(r -> r.close());
        });
    }

    public CompletableFuture<Void> interruptAllChannels() {
        return this.transportActorContext.interruptAllChannels();
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }
}

