/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.ServerControlMessageListener;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.impl.ReceiveBufferHandler;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.ServerOutputImpl;
import io.zeebe.transport.impl.ServerReceiveHandler;
import io.zeebe.transport.impl.ServerSocketBinding;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.Receiver;
import io.zeebe.transport.impl.actor.Sender;
import io.zeebe.transport.impl.actor.ServerActorContext;
import io.zeebe.transport.impl.actor.ServerConductor;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorScheduler;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Objects;

public class ServerTransportBuilder {
    public static final String SEND_BUFFER_SUBSCRIPTION_NAME = "sender";
    private int messageMaxLength = 524288;
    private Dispatcher sendBuffer;
    private ServerOutput output;
    private ActorScheduler scheduler;
    private InetSocketAddress bindAddress;
    protected FragmentHandler receiveHandler;
    protected RemoteAddressListImpl remoteAddressList;
    protected ServerControlMessageListener controlMessageListener;

    public ServerTransportBuilder bindAddress(InetSocketAddress address) {
        this.bindAddress = address;
        return this;
    }

    public ServerTransportBuilder scheduler(ActorScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ServerTransportBuilder sendBuffer(Dispatcher sendBuffer) {
        this.sendBuffer = sendBuffer;
        this.output = new ServerOutputImpl(sendBuffer);
        return this;
    }

    public ServerTransportBuilder messageMaxLength(int messageMaxLength) {
        this.messageMaxLength = messageMaxLength;
        return this;
    }

    protected ServerTransportBuilder receiveHandler(FragmentHandler receiveHandler) {
        this.receiveHandler = receiveHandler;
        return this;
    }

    public ServerTransportBuilder controlMessageListener(ServerControlMessageListener controlMessageListener) {
        this.controlMessageListener = controlMessageListener;
        return this;
    }

    public ServerTransport build(ServerMessageHandler messageHandler, ServerRequestHandler requestHandler) {
        this.remoteAddressList = new RemoteAddressListImpl();
        this.receiveHandler(new ServerReceiveHandler(this.output, this.remoteAddressList, messageHandler, requestHandler, this.controlMessageListener));
        this.validate();
        TransportContext context = this.buildTransportContext();
        ServerActorContext actorContext = new ServerActorContext();
        this.buildActors(context, actorContext);
        return new ServerTransport(actorContext, context);
    }

    public BufferingServerTransport buildBuffering(Dispatcher receiveBuffer) {
        this.remoteAddressList = new RemoteAddressListImpl();
        this.receiveHandler(new ReceiveBufferHandler(receiveBuffer));
        this.validate();
        TransportContext context = this.buildTransportContext();
        ServerActorContext actorContext = new ServerActorContext();
        context.setReceiveBuffer(receiveBuffer);
        this.buildActors(context, actorContext);
        return new BufferingServerTransport(actorContext, context);
    }

    protected TransportContext buildTransportContext() {
        ServerSocketBinding serverSocketBinding = new ServerSocketBinding(this.bindAddress);
        serverSocketBinding.doBind();
        TransportContext context = new TransportContext();
        context.setServerOutput(this.output);
        context.setMessageMaxLength(this.messageMaxLength);
        context.setRemoteAddressList(this.remoteAddressList);
        context.setReceiveHandler(this.receiveHandler);
        context.setServerSocketBinding(serverSocketBinding);
        context.setSenderSubscription(this.sendBuffer.getSubscriptionByName(SEND_BUFFER_SUBSCRIPTION_NAME));
        return context;
    }

    protected void buildActors(TransportContext context, ServerActorContext actorContext) {
        ServerConductor conductor = new ServerConductor(actorContext, context);
        Sender sender = new Sender(actorContext, context);
        Receiver receiver = new Receiver(actorContext, context);
        context.setActorReferences(Arrays.asList(this.scheduler.schedule((Actor)conductor), this.scheduler.schedule((Actor)sender), this.scheduler.schedule((Actor)receiver)));
    }

    protected void validate() {
        Objects.requireNonNull(this.scheduler, "Scheduler must be provided");
        Objects.requireNonNull(this.sendBuffer, "Send buffer must be provided");
        Objects.requireNonNull(this.bindAddress, "Bind Address must be provided");
        Objects.requireNonNull(this.receiveHandler, "Receive Handler must be defined");
    }
}

