/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.ClaimedFragment;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.buffer.DirectBufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class TransportMessage {
    protected final TransportHeaderDescriptor transportHeaderDescriptor = new TransportHeaderDescriptor();
    protected final ClaimedFragment claimedFragment = new ClaimedFragment();
    protected BufferWriter writer;
    protected DirectBufferWriter writerAdapter = new DirectBufferWriter();
    protected int remoteStreamId;

    public TransportMessage writer(BufferWriter writer) {
        this.writer = writer;
        return this;
    }

    public TransportMessage buffer(DirectBuffer buffer) {
        return this.buffer(buffer, 0, buffer.capacity());
    }

    public TransportMessage buffer(DirectBuffer buffer, int offset, int length) {
        return this.writer((BufferWriter)this.writerAdapter.wrap(buffer, offset, length));
    }

    public TransportMessage remoteAddress(RemoteAddress remoteAddress) {
        this.remoteStreamId = remoteAddress.getStreamId();
        return this;
    }

    public TransportMessage remoteStreamId(int remoteStreamId) {
        this.remoteStreamId = remoteStreamId;
        return this;
    }

    public TransportMessage reset() {
        this.remoteStreamId = -1;
        this.writer = null;
        return this;
    }

    public boolean trySend(Dispatcher sendBuffer) {
        long claimedOffset;
        int requiredLength = TransportHeaderDescriptor.framedLength(this.writer.getLength());
        while ((claimedOffset = sendBuffer.claim(this.claimedFragment, requiredLength, this.remoteStreamId)) == -2L) {
        }
        if (claimedOffset >= 0L) {
            try {
                MutableDirectBuffer buffer = this.claimedFragment.getBuffer();
                int writeOffset = this.claimedFragment.getOffset();
                this.transportHeaderDescriptor.wrap((DirectBuffer)buffer, writeOffset).putProtocolSingleMessage();
                this.writer.write(buffer, writeOffset += TransportHeaderDescriptor.headerLength());
                this.claimedFragment.commit();
                return true;
            }
            catch (Throwable e) {
                this.claimedFragment.abort();
            }
        }
        return false;
    }
}

