/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.ClientRequest;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.TransportMessage;
import io.zeebe.transport.impl.ClientRequestPool;
import io.zeebe.transport.impl.RequestManager;
import io.zeebe.util.buffer.BufferWriter;

public class ClientOutputImpl
implements ClientOutput {
    protected final Dispatcher sendBuffer;
    protected final ClientRequestPool requestPool;
    protected final RequestManager requestManager;
    protected final long defaultRequestRetryTimeout;

    public ClientOutputImpl(Dispatcher sendBuffer, ClientRequestPool requestPool, RequestManager requestManager, long defaultRequestRetryTimeout) {
        this.sendBuffer = sendBuffer;
        this.requestPool = requestPool;
        this.requestManager = requestManager;
        this.defaultRequestRetryTimeout = defaultRequestRetryTimeout;
    }

    @Override
    public boolean sendMessage(TransportMessage transportMessage) {
        return transportMessage.trySend(this.sendBuffer);
    }

    @Override
    public ClientRequest sendRequest(RemoteAddress addr, BufferWriter writer) {
        return this.requestPool.openRequest(addr, writer);
    }

    @Override
    public ClientRequest sendRequestWithRetry(RemoteAddress addr, BufferWriter writer, long timeout) {
        this.ensureRequestManagerEnabled();
        return this.requestManager.openRequest(addr, writer, timeout);
    }

    @Override
    public ClientRequest sendRequestWithRetry(RemoteAddress addr, BufferWriter writer) {
        return this.sendRequestWithRetry(addr, writer, this.defaultRequestRetryTimeout);
    }

    private void ensureRequestManagerEnabled() {
        if (this.requestManager == null) {
            throw new UnsupportedOperationException("Managed requests are disabled. Must be enabled on the client transport builder");
        }
    }
}

