/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.ClaimedFragment;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.transport.ClientRequest;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.impl.ClientRequestPool;
import io.zeebe.transport.impl.FutureImpl;
import io.zeebe.transport.impl.RequestResponseHeaderDescriptor;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import io.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ClientRequestImpl
implements ClientRequest {
    private final TransportHeaderDescriptor transportHeaderDescriptor = new TransportHeaderDescriptor();
    private final RequestResponseHeaderDescriptor requestResponseHeader = new RequestResponseHeaderDescriptor();
    private final Consumer<ClientRequestImpl> closeHandler;
    private final ClientRequestPool.RequestIdGenerator requestIdGenerator;
    private final Dispatcher sendBuffer;
    private final ClaimedFragment sendBufferClaim = new ClaimedFragment();
    private volatile long requestId;
    private RemoteAddress remoteAddress;
    private final FutureImpl responseFuture = new FutureImpl();

    public ClientRequestImpl(ClientRequestPool.RequestIdGenerator requestIdGenerator, Dispatcher sendBuffer, Consumer<ClientRequestImpl> closeHandler) {
        this.requestIdGenerator = requestIdGenerator;
        this.sendBuffer = sendBuffer;
        this.closeHandler = closeHandler;
    }

    public void init(RemoteAddress remoteAddress) {
        this.responseFuture.awaitResult();
        this.requestId = this.requestIdGenerator.getNextRequestId();
        this.remoteAddress = remoteAddress;
    }

    public boolean submit(BufferWriter writer) {
        long claimedOffset;
        this.responseFuture.awaitResult();
        int requiredLength = RequestResponseHeaderDescriptor.framedLength(TransportHeaderDescriptor.framedLength(writer.getLength()));
        while ((claimedOffset = this.sendBuffer.claim(this.sendBufferClaim, requiredLength, this.remoteAddress.getStreamId())) == -2L) {
        }
        if (claimedOffset >= 0L) {
            try {
                MutableDirectBuffer buffer = this.sendBufferClaim.getBuffer();
                int writeOffset = this.sendBufferClaim.getOffset();
                this.transportHeaderDescriptor.wrap((DirectBuffer)buffer, writeOffset).putProtocolRequestReponse();
                this.requestResponseHeader.wrap((DirectBuffer)buffer, writeOffset += TransportHeaderDescriptor.headerLength()).requestId(this.requestId);
                writer.write(buffer, writeOffset += RequestResponseHeaderDescriptor.headerLength());
                this.sendBufferClaim.commit();
                return true;
            }
            catch (Throwable e) {
                this.sendBufferClaim.abort();
                throw e;
            }
        }
        return false;
    }

    public RemoteAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void close() {
        boolean nowClosed = this.responseFuture.close();
        if (nowClosed) {
            this.remoteAddress = null;
            this.requestId = -1L;
            this.closeHandler.accept(this);
        }
    }

    public void fail(String failure, Exception cause) {
        this.responseFuture.fail(failure, cause);
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    public void processResponse(DirectBuffer buff, int offset, int length) {
        this.responseFuture.complete(buff, offset, length);
    }

    @Override
    public DirectBuffer get() throws InterruptedException, ExecutionException {
        return this.responseFuture.get();
    }

    @Override
    public DirectBuffer join() {
        return this.responseFuture.join();
    }

    @Override
    public boolean isCancelled() {
        return this.responseFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.responseFuture.isDone();
    }

    public boolean isAwaitingResponse() {
        return this.responseFuture.isAwaitingResult();
    }

    @Override
    public boolean isFailed() {
        return this.responseFuture.isFailed();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectBuffer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.responseFuture.get(timeout, unit);
    }
}

