/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.transport.Loggers;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.impl.ClientRequestImpl;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.BitUtil;
import org.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import org.slf4j.Logger;

public class ClientRequestPool
implements AutoCloseable {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private final int capacity;
    private final ManyToManyConcurrentArrayQueue<ClientRequestImpl> availableRequests;
    private ClientRequestImpl[] requests;

    public ClientRequestPool(int requestedCapacity, Dispatcher sendBuffer) {
        this.capacity = BitUtil.findNextPositivePowerOfTwo((int)requestedCapacity);
        this.availableRequests = new ManyToManyConcurrentArrayQueue(this.capacity);
        this.requests = new ClientRequestImpl[this.capacity];
        for (int i = 0; i < this.capacity; ++i) {
            ClientRequestImpl request;
            this.requests[i] = request = new ClientRequestImpl(new RequestIdGenerator(i, this.capacity), sendBuffer, this::returnRequest);
            this.availableRequests.add((Object)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRequestImpl openRequest(RemoteAddress remote, BufferWriter writer) {
        ClientRequestImpl request = this.poll(remote);
        if (request != null) {
            boolean requestSubmitted = false;
            try {
                requestSubmitted = request.submit(writer);
            }
            finally {
                if (!requestSubmitted) {
                    request.close();
                    request = null;
                }
            }
        }
        return request;
    }

    public ClientRequestImpl poll(RemoteAddress remote) {
        ClientRequestImpl request = (ClientRequestImpl)this.availableRequests.poll();
        if (request != null) {
            request.init(remote);
        }
        return request;
    }

    public ClientRequestImpl getOpenRequestById(long id) {
        ClientRequestImpl result = null;
        int offset = (int)(id & (long)(this.capacity - 1));
        ClientRequestImpl request = this.requests[offset];
        if (request.getRequestId() == id) {
            result = request;
        }
        return result;
    }

    public void failPendingRequestsToRemote(RemoteAddress remote, String reason) {
        for (int i = 0; i < this.requests.length; ++i) {
            ClientRequestImpl request = this.requests[i];
            if (!request.isAwaitingResponse() || !remote.equals(request.getRemoteAddress())) continue;
            request.fail(reason, null);
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.requests.length; ++i) {
            ClientRequestImpl clientRequestImpl = this.requests[i];
            try {
                clientRequestImpl.close();
                continue;
            }
            catch (Exception e) {
                LOG.debug("Failed to close client request {}", (Object)clientRequestImpl, (Object)e);
            }
        }
    }

    public void returnRequest(ClientRequestImpl requestImpl) {
        this.availableRequests.add((Object)requestImpl);
    }

    public static class RequestIdGenerator {
        private final int poolCapacity;
        private long lastId;

        RequestIdGenerator(int offset, int poolCapacity) {
            this.poolCapacity = poolCapacity;
            this.lastId = offset;
        }

        public long getNextRequestId() {
            this.lastId += (long)this.poolCapacity;
            return this.lastId;
        }
    }
}

