/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.impl.ClientRequestImpl;
import io.zeebe.transport.impl.ClientRequestPool;
import io.zeebe.transport.impl.RequestResponseHeaderDescriptor;
import io.zeebe.transport.impl.SendFailureHandler;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import org.agrona.DirectBuffer;

public class ClientSendFailureHandler
implements SendFailureHandler {
    private final TransportHeaderDescriptor transportHeaderDescriptor = new TransportHeaderDescriptor();
    private final RequestResponseHeaderDescriptor requestResponseHeaderDescriptor = new RequestResponseHeaderDescriptor();
    protected final ClientRequestPool requestPool;

    public ClientSendFailureHandler(ClientRequestPool requestPool) {
        this.requestPool = requestPool;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, int streamId, String failure, Exception cause) {
        int protocolId = this.transportHeaderDescriptor.wrap(buffer, offset).protocolId();
        if (protocolId == 0) {
            this.requestResponseHeaderDescriptor.wrap(buffer, offset + TransportHeaderDescriptor.HEADER_LENGTH);
            long requestId = this.requestResponseHeaderDescriptor.requestId();
            ClientRequestImpl pendingRequest = this.requestPool.getOpenRequestById(requestId);
            if (pendingRequest != null) {
                pendingRequest.fail(failure, cause);
            }
        }
    }
}

