/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;

public class FutureImpl
implements Future<DirectBuffer> {
    private static final AtomicIntegerFieldUpdater<FutureImpl> STATE_FIELD = AtomicIntegerFieldUpdater.newUpdater(FutureImpl.class, "state");
    private static final int AWAITING_RESULT = 1;
    private static final int RESULT_AVAILABLE = 2;
    private static final int FAILED = 3;
    private static final int CLOSED = 4;
    private volatile int state = 4;
    private final MutableDirectBuffer responseBuffer = new ExpandableArrayBuffer();
    private final UnsafeBuffer responseBufferView = new UnsafeBuffer(0L, 0);
    private final IdleStrategy awaitResponseStrategy = new BackoffIdleStrategy(1000L, 100L, 1L, TimeUnit.MILLISECONDS.toNanos(1L));
    protected String failure;
    protected Exception failureCause;

    public void awaitResult() {
        STATE_FIELD.set(this, 1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return STATE_FIELD.get(this) != 1;
    }

    public boolean isFailed() {
        return STATE_FIELD.get(this) == 3;
    }

    public boolean isAwaitingResult() {
        return STATE_FIELD.get(this) == 1;
    }

    @Override
    public DirectBuffer get() throws InterruptedException, ExecutionException {
        try {
            return this.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DirectBuffer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.awaitResponseStrategy.reset();
        long maxWait = System.nanoTime() + unit.toNanos(timeout);
        do {
            int state = STATE_FIELD.get(this);
            switch (state) {
                case 2: {
                    return this.responseBufferView;
                }
                case 4: {
                    throw new ExecutionException(new RuntimeException("Future closed; If you see this exception, you should no longer hold this object (reuse)"));
                }
                case 3: {
                    throw new ExecutionException(this.failure, this.failureCause);
                }
            }
            this.awaitResponseStrategy.idle();
        } while (System.nanoTime() < maxWait);
        throw new TimeoutException();
    }

    public void complete(DirectBuffer buff, int offset, int length) {
        if (STATE_FIELD.get(this) == 1) {
            this.responseBuffer.putBytes(0, buff, offset, length);
            this.responseBufferView.wrap((DirectBuffer)this.responseBuffer, 0, length);
            STATE_FIELD.compareAndSet(this, 1, 2);
        }
    }

    public void fail(String failure, Exception cause) {
        if (STATE_FIELD.compareAndSet(this, 1, 3)) {
            this.failure = failure;
            this.failureCause = cause;
        }
    }

    public DirectBuffer join() {
        try {
            return this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean close() {
        int prevState = STATE_FIELD.getAndSet(this, 4);
        if (prevState != 4) {
            this.failure = null;
            this.failureCause = null;
        }
        return prevState != 4;
    }

    public boolean isClosed() {
        return STATE_FIELD.get(this) == 4;
    }
}

