/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.ClientRequest;
import io.zeebe.transport.NotConnectedException;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RequestTimeoutException;
import io.zeebe.transport.impl.ClientRequestImpl;
import io.zeebe.transport.impl.FutureImpl;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.buffer.DirectBufferWriter;
import io.zeebe.util.state.SimpleStateMachineContext;
import io.zeebe.util.state.State;
import io.zeebe.util.state.StateMachine;
import io.zeebe.util.state.StateMachineAgent;
import io.zeebe.util.state.WaitState;
import io.zeebe.util.time.ClockUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public class ManagedClientRequestImpl
implements ClientRequest {
    private static final long RESUBMIT_TIMEOUT = 100L;
    protected final long deadline;
    protected final long id;
    protected final RemoteAddress endpoint;
    protected final FutureImpl responseFuture = new FutureImpl();
    protected final ClientRequestImpl request;
    protected ExpandableArrayBuffer requestBuffer = new ExpandableArrayBuffer();
    protected DirectBufferWriter requestWriter = new DirectBufferWriter();
    protected final StateMachineAgent<StateMachineContext> stateMachine;
    protected static final int TRANSITION_DEFAULT = 0;
    protected static final int TRANSITION_RESOLVE = 1;
    protected static final int TRANSITION_RETRY = 2;
    protected static final int TRANSITION_CLOSE = 3;
    protected static final SubmitRequestState OPEN_REQUEST_STATE = new SubmitRequestState();
    protected static final AwaitResponseState AWAIT_RESPONSE_STATE = new AwaitResponseState();
    protected static final ResolvedState RESOLVED_STATE = new ResolvedState();
    protected static final ClosedState CLOSED_STATE = new ClosedState();

    public ManagedClientRequestImpl(ClientRequestImpl request, RemoteAddress endpoint, BufferWriter writer, long timeout) {
        this.deadline = ClockUtil.getCurrentTimeInMillis() + timeout;
        this.id = request.getRequestId();
        this.endpoint = endpoint;
        this.request = request;
        int requestLength = writer.getLength();
        writer.write((MutableDirectBuffer)this.requestBuffer, 0);
        this.requestWriter.wrap((DirectBuffer)this.requestBuffer, 0, requestLength);
        this.responseFuture.awaitResult();
        this.stateMachine = new StateMachineAgent(StateMachine.builder(s -> {
            StateMachineContext ctx = new StateMachineContext((StateMachine<?>)s);
            ctx.orchestrator = this;
            ctx.responseFuture = this.responseFuture;
            ctx.request = request;
            ctx.requestWriter = this.requestWriter;
            return ctx;
        }).initialState((State)OPEN_REQUEST_STATE).from((State)OPEN_REQUEST_STATE).take(0).to((State)AWAIT_RESPONSE_STATE).from((State)OPEN_REQUEST_STATE).take(1).to((State)RESOLVED_STATE).from((State)OPEN_REQUEST_STATE).take(3).to((State)CLOSED_STATE).from((State)AWAIT_RESPONSE_STATE).take(1).to((State)RESOLVED_STATE).from((State)AWAIT_RESPONSE_STATE).take(2).to((State)OPEN_REQUEST_STATE).from((State)AWAIT_RESPONSE_STATE).take(3).to((State)CLOSED_STATE).from((State)RESOLVED_STATE).take(3).to((State)CLOSED_STATE).build());
    }

    @Override
    public boolean isDone() {
        return this.responseFuture.isDone();
    }

    public boolean isClosed() {
        return this.responseFuture.isClosed();
    }

    @Override
    public void close() {
        this.stateMachine.addCommand(s -> s.tryTake(3));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public DirectBuffer get() throws InterruptedException, ExecutionException {
        return this.responseFuture.get();
    }

    @Override
    public DirectBuffer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.responseFuture.get(timeout, unit);
    }

    @Override
    public long getRequestId() {
        return this.id;
    }

    @Override
    public DirectBuffer join() {
        return this.responseFuture.join();
    }

    @Override
    public boolean isFailed() {
        return this.responseFuture.isFailed();
    }

    public int doWork() {
        return this.stateMachine.doWork();
    }

    protected boolean isTimedOut() {
        return ClockUtil.getCurrentTimeInMillis() > this.deadline;
    }

    protected static class StateMachineContext
    extends SimpleStateMachineContext {
        protected ManagedClientRequestImpl orchestrator;
        protected FutureImpl responseFuture;
        protected ClientRequestImpl request;
        protected BufferWriter requestWriter;
        protected long submitTimeout = -1L;

        public StateMachineContext(StateMachine<?> stateMachine) {
            super(stateMachine);
        }

        protected void doNotResubmitBefore(long duration) {
            this.submitTimeout = ClockUtil.getCurrentTimeInMillis() + duration;
        }

        protected boolean canSubmit() {
            return this.submitTimeout < ClockUtil.getCurrentTimeInMillis();
        }

        protected void timeOut() {
            String reason = "Request timed out";
            this.fail("Request timed out", new RequestTimeoutException("Request timed out"));
        }

        protected void fail(String reason, Exception cause) {
            this.responseFuture.fail(reason, cause);
            this.resolve();
        }

        protected void resolve() {
            this.request.close();
            this.take(1);
        }
    }

    protected static class ClosedState
    implements WaitState<StateMachineContext> {
        protected ClosedState() {
        }

        public void onEnter(StateMachineContext context) {
            boolean responseDone = context.responseFuture.isDone();
            boolean nowClosed = context.responseFuture.close();
            if (nowClosed && !responseDone) {
                context.request.close();
            }
        }

        public void work(StateMachineContext context) throws Exception {
        }
    }

    protected static class ResolvedState
    implements WaitState<StateMachineContext> {
        protected ResolvedState() {
        }

        public void work(StateMachineContext context) throws Exception {
        }
    }

    protected static class AwaitResponseState
    implements State<StateMachineContext> {
        protected AwaitResponseState() {
        }

        public int doWork(StateMachineContext context) throws Exception {
            if (context.orchestrator.isTimedOut()) {
                context.timeOut();
                return 1;
            }
            if (context.request.isDone()) {
                DirectBuffer result = null;
                try {
                    result = context.request.get();
                }
                catch (Exception e) {
                    if (e instanceof ExecutionException && ((ExecutionException)e).getCause() instanceof NotConnectedException) {
                        context.doNotResubmitBefore(100L);
                        context.take(2);
                    }
                    context.fail("Request failed", e);
                }
                if (result != null) {
                    context.responseFuture.complete(result, 0, result.capacity());
                    context.resolve();
                }
                return 1;
            }
            return 0;
        }
    }

    protected static class SubmitRequestState
    implements State<StateMachineContext> {
        protected SubmitRequestState() {
        }

        public int doWork(StateMachineContext context) throws Exception {
            if (context.orchestrator.isTimedOut()) {
                context.timeOut();
                return 1;
            }
            if (!context.canSubmit()) {
                return 0;
            }
            boolean success = context.request.submit(context.requestWriter);
            if (success) {
                context.take(0);
                return 1;
            }
            return 0;
        }
    }
}

