/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.impl.RemoteAddressImpl;
import java.util.Iterator;

public class RemoteAddressListImpl
implements RemoteAddressList {
    private volatile int size;
    private RemoteAddressImpl[] index = new RemoteAddressImpl[0];
    protected AddressIterator iterator = new AddressIterator();

    @Override
    public RemoteAddressImpl getByStreamId(int streamId) {
        if (streamId < this.size) {
            return this.index[streamId];
        }
        return null;
    }

    @Override
    public RemoteAddressImpl getByAddress(SocketAddress inetSocketAddress) {
        return this.getByAddress(inetSocketAddress, 1);
    }

    public RemoteAddressImpl getByAddress(SocketAddress inetSocketAddress, int stateMask) {
        int currSize = this.size;
        for (int i = 0; i < currSize; ++i) {
            RemoteAddressImpl remoteAddress = this.index[i];
            if (remoteAddress == null || !remoteAddress.getAddress().equals(inetSocketAddress) || !remoteAddress.isInAnyState(stateMask)) continue;
            return remoteAddress;
        }
        return null;
    }

    @Override
    public synchronized void retire(RemoteAddress remote) {
        this.getByStreamId(remote.getStreamId()).retire();
    }

    @Override
    public synchronized void deactivate(RemoteAddress remote) {
        this.getByStreamId(remote.getStreamId()).deactivate();
    }

    @Override
    public synchronized void deactivateAll() {
        for (int i = 0; i < this.size; ++i) {
            this.index[i].deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteAddressImpl register(SocketAddress inetSocketAddress) {
        RemoteAddressImpl result = this.getByAddress(inetSocketAddress);
        if (result == null) {
            RemoteAddressListImpl remoteAddressListImpl = this;
            synchronized (remoteAddressListImpl) {
                result = this.getByAddress(inetSocketAddress, 3);
                if (result == null) {
                    int prevSize = this.size;
                    int newSize = prevSize + 1;
                    RemoteAddressImpl remoteAddress = new RemoteAddressImpl(prevSize, new SocketAddress(inetSocketAddress));
                    RemoteAddressImpl[] newAddresses = new RemoteAddressImpl[newSize];
                    System.arraycopy(this.index, 0, newAddresses, 0, prevSize);
                    newAddresses[remoteAddress.getStreamId()] = remoteAddress;
                    this.index = newAddresses;
                    this.size = newSize;
                    result = remoteAddress;
                } else if (result.isInAnyState(2)) {
                    result.activate();
                }
            }
        }
        return result;
    }

    public Iterator<RemoteAddressImpl> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    protected class AddressIterator
    implements Iterator<RemoteAddressImpl> {
        protected int curr = 0;
        protected int currentSize;

        protected AddressIterator() {
        }

        public void reset() {
            this.curr = 0;
            this.currentSize = RemoteAddressListImpl.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.currentSize;
        }

        @Override
        public RemoteAddressImpl next() {
            RemoteAddressImpl next = RemoteAddressListImpl.this.index[this.curr];
            ++this.curr;
            return next;
        }
    }
}

