/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.impl.ClientRequestImpl;
import io.zeebe.transport.impl.ClientRequestPool;
import io.zeebe.transport.impl.ManagedClientRequestImpl;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;

public class RequestManager
implements Actor {
    protected final ManyToOneConcurrentArrayQueue<ManagedClientRequestImpl> stagedRequests = new ManyToOneConcurrentArrayQueue(128);
    protected final ArrayList<ManagedClientRequestImpl> activeRequests = new ArrayList();
    protected final ClientRequestPool requestPool;

    public RequestManager(ClientRequestPool requestPool) {
        this.requestPool = requestPool;
    }

    public int doWork() throws Exception {
        int workCount = this.stagedRequests.drain(this.activeRequests::add);
        for (int i = 0; i < this.activeRequests.size(); ++i) {
            ManagedClientRequestImpl requestImpl = this.activeRequests.get(i);
            workCount += requestImpl.doWork();
            if (!requestImpl.isClosed()) continue;
            ArrayListUtil.fastUnorderedRemove(this.activeRequests, (int)i);
            --i;
        }
        return workCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedClientRequestImpl openRequest(RemoteAddress addr, BufferWriter writer, long timeout) {
        ManagedClientRequestImpl resilientRequest = null;
        ClientRequestImpl request = this.requestPool.poll(addr);
        if (request != null) {
            try {
                resilientRequest = new ManagedClientRequestImpl(request, addr, writer, timeout);
            }
            finally {
                if (resilientRequest == null) {
                    request.close();
                } else {
                    boolean staged = this.stagedRequests.offer((Object)resilientRequest);
                    if (!staged) {
                        request.close();
                        resilientRequest = null;
                    }
                }
            }
        }
        return resilientRequest;
    }
}

