/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.Loggers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class ServerSocketBinding {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final List<Selector> registeredSelectors = Collections.synchronizedList(new ArrayList());
    protected final InetSocketAddress bindAddress;
    protected ServerSocketChannel media;

    public ServerSocketBinding(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void doBind() {
        try {
            this.media = ServerSocketChannel.open();
            this.media.bind(this.bindAddress);
            this.media.configureBlocking(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to bind to address: " + this.bindAddress, e);
        }
    }

    public void registerSelector(Selector selector, int op) {
        try {
            SelectionKey key = this.media.register(selector, op);
            key.attach(this);
            this.registeredSelectors.add(selector);
        }
        catch (ClosedChannelException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeSelector(Selector selector) {
        SelectionKey key = this.media.keyFor(selector);
        if (key != null) {
            key.cancel();
            try {
                selector.select(1L);
            }
            catch (IOException e) {
                LOG.debug("Failed to remove selector {}", (Object)selector, (Object)e);
            }
        }
    }

    public SocketChannel accept() {
        try {
            SocketChannel socketChannel = this.media.accept();
            socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            socketChannel.configureBlocking(false);
            return socketChannel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            List<Selector> list = this.registeredSelectors;
            synchronized (list) {
                this.registeredSelectors.forEach(s -> this.removeSelector((Selector)s));
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to close selectors", (Throwable)e);
        }
        try {
            this.media.close();
        }
        catch (IOException e) {
            LOG.debug("Failed to close media", (Throwable)e);
        }
    }
}

