/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.TransportListener;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.actor.Conductor;
import io.zeebe.transport.impl.actor.Receiver;
import io.zeebe.transport.impl.actor.Sender;
import java.util.concurrent.CompletableFuture;

public abstract class ActorContext {
    private Conductor conductor;
    private Sender sender;
    private Receiver receiver;

    public void setConductor(Conductor clientConductor) {
        this.conductor = clientConductor;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void registerChannel(TransportChannel ch) {
        this.sender.registerChannel(ch);
        this.receiver.registerChannel(ch);
    }

    public void removeChannel(TransportChannel ch) {
        this.sender.removeChannel(ch);
        this.receiver.removeChannel(ch);
    }

    public void removeListener(TransportListener listener) {
        this.conductor.removeListener(listener);
    }

    public CompletableFuture<Void> registerListener(TransportListener channelListener) {
        return this.conductor.registerListener(channelListener);
    }

    public CompletableFuture<Void> onClose() {
        return this.conductor.onClose().whenComplete((v, t) -> this.receiver.closeSelectors());
    }

    public CompletableFuture<Void> closeAllOpenChannels() {
        return this.conductor.closeCurrentChannels();
    }

    public CompletableFuture<Void> interruptAllChannels() {
        return this.conductor.interruptAllChannels();
    }
}

