/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.impl.RemoteAddressImpl;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.actor.ClientConductor;
import java.util.Iterator;
import org.agrona.collections.Int2ObjectHashMap;

public class ClientChannelManager {
    protected Int2ObjectHashMap<TransportChannel> channels = new Int2ObjectHashMap();
    protected final RemoteAddressListImpl registeredAddresses;
    protected final ClientConductor conductor;

    public ClientChannelManager(ClientConductor conductor, RemoteAddressListImpl registeredAddresses) {
        this.registeredAddresses = registeredAddresses;
        this.conductor = conductor;
    }

    public int maintainChannels() {
        int workCount = 0;
        workCount += this.openNewChannels();
        return workCount += this.reopenChannels();
    }

    private int reopenChannels() {
        int workCount = 0;
        Iterator channelIt = this.channels.values().iterator();
        while (channelIt.hasNext()) {
            TransportChannel channel = (TransportChannel)channelIt.next();
            if (!channel.isClosed()) continue;
            RemoteAddressImpl remoteAddress = channel.getRemoteAddress();
            if (remoteAddress.isActive()) {
                this.openChannel(remoteAddress);
            } else {
                channelIt.remove();
            }
            ++workCount;
        }
        return workCount;
    }

    private int openNewChannels() {
        Iterator<RemoteAddressImpl> addressIt = this.registeredAddresses.iterator();
        int workCount = 0;
        while (addressIt.hasNext()) {
            RemoteAddressImpl address = addressIt.next();
            if (!address.isActive() || this.channels.containsKey(address.getStreamId())) continue;
            this.openChannel(address);
            ++workCount;
        }
        return workCount;
    }

    private void openChannel(RemoteAddressImpl address) {
        TransportChannel channel = this.conductor.openChannel(address);
        if (channel != null) {
            this.channels.put(address.getStreamId(), (Object)channel);
        }
    }
}

