/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.impl.RemoteAddressImpl;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.transport.impl.actor.ClientChannelManager;
import io.zeebe.transport.impl.actor.Conductor;
import io.zeebe.transport.impl.selector.ConnectTransportPoller;
import org.agrona.nio.TransportPoller;

public class ClientConductor
extends Conductor {
    private final ConnectTransportPoller connectTransportPoller = new ConnectTransportPoller();
    private final TransportPoller[] closableTransportPoller = new TransportPoller[]{this.connectTransportPoller};
    private final ClientChannelManager channelManager;

    public ClientConductor(ActorContext actorContext, TransportContext context) {
        super(actorContext, context);
        this.channelManager = new ClientChannelManager(this, context.getRemoteAddressList());
    }

    @Override
    public int doWork() throws Exception {
        int workCount = super.doWork();
        workCount += this.connectTransportPoller.doWork();
        return workCount += this.channelManager.maintainChannels();
    }

    public TransportChannel openChannel(RemoteAddressImpl address) {
        TransportChannel channel = this.channelFactory.buildClientChannel(this, address, this.transportContext.getMessageMaxLength(), this.transportContext.getReceiveHandler());
        if (channel.beginConnect()) {
            this.connectTransportPoller.addChannel(channel);
            return channel;
        }
        return null;
    }

    @Override
    protected TransportPoller[] getClosableTransportPoller() {
        return this.closableTransportPoller;
    }
}

