/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.Loggers;
import io.zeebe.transport.TransportListener;
import io.zeebe.transport.impl.ClientRequestPool;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportChannelFactory;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.util.DeferredCommandContext;
import io.zeebe.util.actor.Actor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.nio.TransportPoller;
import org.slf4j.Logger;

public abstract class Conductor
implements Actor,
TransportChannel.ChannelLifecycleListener {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final DeferredCommandContext deferred = new DeferredCommandContext();
    protected final RemoteAddressListImpl remoteAddressList;
    protected final TransportContext transportContext;
    private final List<TransportListener> transportListeners = new ArrayList<TransportListener>();
    private final List<TransportChannel> transportChannels = new ArrayList<TransportChannel>();
    private final ActorContext actorContext;
    protected final AtomicBoolean closing = new AtomicBoolean(false);
    protected final TransportChannelFactory channelFactory;

    public Conductor(ActorContext actorContext, TransportContext context) {
        this.actorContext = actorContext;
        this.transportContext = context;
        this.remoteAddressList = context.getRemoteAddressList();
        this.channelFactory = context.getChannelFactory();
        actorContext.setConductor(this);
    }

    public int getPriority(long now) {
        return 1;
    }

    public int doWork() throws Exception {
        int workCount = 0;
        return workCount += this.deferred.doWork();
    }

    public CompletableFuture<Void> registerListener(TransportListener channelListener) {
        return this.deferred.runAsync(future -> {
            this.transportListeners.add(channelListener);
            future.complete(null);
        });
    }

    public void removeListener(TransportListener channelListener) {
        this.deferred.runAsync(() -> this.transportListeners.remove(channelListener));
    }

    @Override
    public void onChannelConnected(TransportChannel ch) {
        this.deferred.runAsync(() -> {
            this.transportChannels.add(ch);
            this.actorContext.registerChannel(ch);
            this.transportListeners.forEach(l -> {
                try {
                    l.onConnectionEstablished(ch.getRemoteAddress());
                }
                catch (Exception e) {
                    LOG.debug("Failed to call transport listener {} on channel connect", l, (Object)e);
                }
            });
        });
    }

    public CompletableFuture<Void> interruptAllChannels() {
        return this.deferred.runAsync(future -> {
            for (int i = 0; i < this.transportChannels.size(); ++i) {
                TransportChannel channel = this.transportChannels.get(i);
                channel.shutdownInput();
            }
            future.complete(null);
        });
    }

    @Override
    public void onChannelDisconnected(TransportChannel ch) {
        this.deferred.runAsync(() -> {
            this.transportChannels.remove(ch);
            this.failRequestsOnChannel(ch, "Socket channel has been disconnected");
            this.actorContext.removeChannel(ch);
            this.transportListeners.forEach(l -> {
                try {
                    l.onConnectionClosed(ch.getRemoteAddress());
                }
                catch (Exception e) {
                    LOG.debug("Failed to call transport listener {} on disconnect", l, (Object)e);
                }
            });
        });
    }

    protected void failRequestsOnChannel(TransportChannel ch, String reason) {
        ClientRequestPool clientRequestPool = this.transportContext.getClientRequestPool();
        if (clientRequestPool != null) {
            clientRequestPool.failPendingRequestsToRemote(ch.getRemoteAddress(), reason);
        }
    }

    public CompletableFuture<Void> onClose() {
        if (this.closing.compareAndSet(false, true)) {
            this.remoteAddressList.deactivateAll();
            return CompletableFuture.allOf(this.closeClosableTransportPoller(), this.closeCurrentChannels());
        }
        return CompletableFuture.completedFuture(null);
    }

    protected abstract TransportPoller[] getClosableTransportPoller();

    protected CompletableFuture<Void> closeClosableTransportPoller() {
        return this.deferred.runAsync(f -> {
            TransportPoller[] toClosableResources;
            for (TransportPoller closeable : toClosableResources = this.getClosableTransportPoller()) {
                closeable.close();
            }
            f.complete(null);
        });
    }

    public CompletableFuture<Void> closeCurrentChannels() {
        return this.deferred.runAsync(f -> {
            ArrayList<TransportChannel> listCopy = new ArrayList<TransportChannel>(this.transportChannels);
            for (TransportChannel transportChannel : listCopy) {
                transportChannel.close();
            }
            f.complete(null);
        });
    }
}

