/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.transport.impl.selector.ReadTransportPoller;
import io.zeebe.util.DeferredCommandContext;
import io.zeebe.util.actor.Actor;

public class Receiver
implements Actor {
    protected final DeferredCommandContext commandContext = new DeferredCommandContext();
    protected final ReadTransportPoller transportPoller = new ReadTransportPoller();

    public Receiver(ActorContext actorContext, TransportContext context) {
        actorContext.setReceiver(this);
    }

    public int doWork() throws Exception {
        int work = 0;
        work += this.commandContext.doWork();
        return work += this.transportPoller.pollNow();
    }

    public void closeSelectors() {
        this.transportPoller.clearChannels();
        this.transportPoller.close();
    }

    public String name() {
        return "receiver";
    }

    public void removeChannel(TransportChannel c) {
        this.commandContext.runAsync(() -> this.transportPoller.removeChannel(c));
    }

    public void registerChannel(TransportChannel c) {
        this.commandContext.runAsync(future -> this.transportPoller.addChannel(c));
    }
}

