/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.impl.RemoteAddressImpl;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.Conductor;
import io.zeebe.transport.impl.actor.ServerActorContext;
import io.zeebe.transport.impl.selector.AcceptTransportPoller;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.agrona.nio.TransportPoller;

public class ServerConductor
extends Conductor {
    private final AcceptTransportPoller acceptTransportPoller;
    private final TransportPoller[] closableTransportPoller;

    public ServerConductor(ServerActorContext actorContext, TransportContext context) {
        super(actorContext, context);
        this.acceptTransportPoller = new AcceptTransportPoller(actorContext);
        this.acceptTransportPoller.addServerSocketBinding(context.getServerSocketBinding());
        this.closableTransportPoller = new TransportPoller[]{this.acceptTransportPoller};
    }

    @Override
    public int doWork() throws Exception {
        int workCount = super.doWork();
        return workCount += this.acceptTransportPoller.pollNow();
    }

    public void onServerChannelOpened(SocketChannel serverChannel) {
        this.deferred.runAsync(() -> {
            SocketAddress socketAddress = null;
            try {
                socketAddress = new SocketAddress((InetSocketAddress)serverChannel.getRemoteAddress());
            }
            catch (IOException e) {
                try {
                    serverChannel.close();
                }
                catch (IOException e1) {
                    return;
                }
            }
            RemoteAddressImpl remoteAddress = this.remoteAddressList.getByAddress(socketAddress);
            if (remoteAddress != null) {
                this.remoteAddressList.retire(remoteAddress);
            }
            remoteAddress = this.remoteAddressList.register(socketAddress);
            TransportChannel ch = this.channelFactory.buildServerChannel(this, remoteAddress, this.transportContext.getMessageMaxLength(), this.transportContext.getReceiveHandler(), serverChannel);
            this.onChannelConnected(ch);
        });
    }

    @Override
    protected TransportPoller[] getClosableTransportPoller() {
        return this.closableTransportPoller;
    }
}

