/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.selector;

import io.zeebe.transport.impl.ServerSocketBinding;
import io.zeebe.transport.impl.actor.ServerActorContext;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.function.ToIntFunction;
import org.agrona.LangUtil;
import org.agrona.nio.TransportPoller;

public class AcceptTransportPoller
extends TransportPoller {
    protected final ToIntFunction<SelectionKey> processKeyFn = this::processKey;
    private final ServerActorContext actorContext;

    public AcceptTransportPoller(ServerActorContext actorContext) {
        this.actorContext = actorContext;
    }

    public int pollNow() {
        int workCount = 0;
        if (this.selector.isOpen()) {
            try {
                this.selector.selectNow();
                if (!this.selectedKeySet.isEmpty()) {
                    workCount = this.selectedKeySet.forEach(this.processKeyFn);
                }
            }
            catch (IOException e) {
                this.selectedKeySet.reset();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        return workCount;
    }

    protected int processKey(SelectionKey key) {
        if (key != null) {
            ServerSocketBinding serverSocketBinding = (ServerSocketBinding)key.attachment();
            SocketChannel serverChannel = serverSocketBinding.accept();
            this.actorContext.onServerChannelOpened(serverChannel);
            return 1;
        }
        return 0;
    }

    public void addServerSocketBinding(ServerSocketBinding binding) {
        binding.registerSelector(this.selector, 16);
    }
}

