/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.selector;

import io.zeebe.transport.impl.TransportChannel;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.function.ToIntFunction;
import org.agrona.LangUtil;
import org.agrona.nio.TransportPoller;

public class ConnectTransportPoller
extends TransportPoller {
    protected final ToIntFunction<SelectionKey> processKeyFn = this::processKey;
    protected int channelCount = 0;

    public int doWork() {
        return this.pollNow();
    }

    public int pollNow() {
        int workCount = 0;
        if (this.channelCount > 0 && this.selector.isOpen()) {
            try {
                this.selector.selectNow();
                workCount = this.selectedKeySet.forEach(this.processKeyFn);
            }
            catch (IOException e) {
                this.selectedKeySet.reset();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        return workCount;
    }

    protected int processKey(SelectionKey key) {
        if (key != null) {
            TransportChannel channel = (TransportChannel)key.attachment();
            this.removeChannel(channel);
            channel.finishConnect();
            return 1;
        }
        return 0;
    }

    public void addChannel(TransportChannel channel) {
        channel.registerSelector(this.selector, 8);
        ++this.channelCount;
    }

    public void removeChannel(TransportChannel channel) {
        channel.removeSelector(this.selector);
        --this.channelCount;
    }
}

