/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.selector;

import io.zeebe.transport.Loggers;
import io.zeebe.transport.impl.TransportChannel;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import org.agrona.LangUtil;
import org.agrona.nio.TransportPoller;
import org.slf4j.Logger;

public class ReadTransportPoller
extends TransportPoller {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final List<TransportChannel> channels = new ArrayList<TransportChannel>();
    protected final ToIntFunction<SelectionKey> processKeyFn = this::processKey;

    public int pollNow() {
        int workCount;
        block4: {
            block3: {
                workCount = 0;
                if (this.channels.size() > 5) break block3;
                for (int i = 0; i < this.channels.size(); ++i) {
                    TransportChannel channel = this.channels.get(i);
                    workCount += channel.receive();
                }
                break block4;
            }
            if (!this.selector.isOpen()) break block4;
            try {
                this.selector.selectNow();
                workCount = this.selectedKeySet.forEach(this.processKeyFn);
            }
            catch (IOException e) {
                this.selectedKeySet.reset();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        return workCount;
    }

    protected int processKey(SelectionKey key) {
        int workCount = 0;
        if (key != null && key.isReadable()) {
            TransportChannel channel = (TransportChannel)key.attachment();
            workCount = channel.receive();
        }
        return workCount;
    }

    public void addChannel(TransportChannel channel) {
        try {
            channel.registerSelector(this.selector, 1);
            this.channels.add(channel);
        }
        catch (Exception e) {
            LOG.debug("Failed to add channel {}", (Object)channel, (Object)e);
        }
    }

    public void removeChannel(TransportChannel channel) {
        this.channels.remove(channel);
    }

    public void clearChannels() {
        this.channels.clear();
    }
}

