/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.BoundaryEvent;
import io.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.zeebe.model.bpmn.instance.EventDefinition;
import io.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.zeebe.model.bpmn.util.ModelUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class BoundaryEventValidator
implements ModelElementValidator<BoundaryEvent> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_EVENT_DEFINITIONS = Arrays.asList(TimerEventDefinition.class, MessageEventDefinition.class, ErrorEventDefinition.class);

    public Class<BoundaryEvent> getElementType() {
        return BoundaryEvent.class;
    }

    public void validate(BoundaryEvent element, ValidationResultCollector validationResultCollector) {
        if (element.getAttachedTo() == null) {
            validationResultCollector.addError(0, "Must be attached to an activity");
        }
        if (element.getIncoming().size() > 0) {
            validationResultCollector.addError(0, "Cannot have incoming sequence flows");
        }
        if (element.getOutgoing().size() < 1) {
            validationResultCollector.addError(0, "Must have at least one outgoing sequence flow");
        }
        this.validateEventDefinition(element, validationResultCollector);
    }

    private void validateEventDefinition(BoundaryEvent element, ValidationResultCollector validationResultCollector) {
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            validationResultCollector.addError(0, "Must have exactly one event definition");
        }
        eventDefinitions.forEach(def -> {
            if (SUPPORTED_EVENT_DEFINITIONS.stream().noneMatch(type -> type.isInstance(def))) {
                validationResultCollector.addError(0, "Boundary events must be one of: timer, message, error");
            }
        });
        ModelUtil.verifyEventDefinition(element, error -> validationResultCollector.addError(0, error));
    }
}

