/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.Process;
import io.zeebe.model.bpmn.instance.StartEvent;
import io.zeebe.model.bpmn.util.ModelUtil;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ProcessValidator
implements ModelElementValidator<Process> {
    public Class<Process> getElementType() {
        return Process.class;
    }

    public void validate(Process element, ValidationResultCollector validationResultCollector) {
        Collection topLevelStartEvents = element.getChildElementsByType(StartEvent.class);
        if (topLevelStartEvents.isEmpty()) {
            validationResultCollector.addError(0, "Must have at least one start event");
        } else if (topLevelStartEvents.stream().filter(this::isNoneEvent).count() > 1L) {
            validationResultCollector.addError(0, "Multiple none start events are not allowed");
        }
        ModelUtil.verifyNoDuplicatedEventSubprocesses(element, error -> validationResultCollector.addError(0, error));
    }

    private boolean isNoneEvent(StartEvent startEvent) {
        return startEvent.getEventDefinitions().isEmpty();
    }
}

