/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl;

import io.zeebe.db.DbKey;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class DbCompositeKey<FirstKeyType extends DbKey, SecondKeyType extends DbKey>
implements DbKey {
    private final FirstKeyType firstKeyTypePart;
    private final SecondKeyType secondKeyTypePart;

    public DbCompositeKey(FirstKeyType firstKeyTypePart, SecondKeyType secondKeyTypePart) {
        this.firstKeyTypePart = firstKeyTypePart;
        this.secondKeyTypePart = secondKeyTypePart;
    }

    public FirstKeyType getFirst() {
        return this.firstKeyTypePart;
    }

    public SecondKeyType getSecond() {
        return this.secondKeyTypePart;
    }

    public void wrap(DirectBuffer directBuffer, int offset, int length) {
        this.firstKeyTypePart.wrap(directBuffer, offset, length);
        int firstKeyLength = this.firstKeyTypePart.getLength();
        this.secondKeyTypePart.wrap(directBuffer, offset + firstKeyLength, length - firstKeyLength);
    }

    public int getLength() {
        return this.firstKeyTypePart.getLength() + this.secondKeyTypePart.getLength();
    }

    public void write(MutableDirectBuffer mutableDirectBuffer, int offset) {
        this.firstKeyTypePart.write(mutableDirectBuffer, offset);
        int firstKeyPartLength = this.firstKeyTypePart.getLength();
        this.secondKeyTypePart.write(mutableDirectBuffer, offset + firstKeyPartLength);
    }
}

