/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl;

import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class DbString
implements DbKey,
DbValue {
    private final DirectBuffer bytes = new UnsafeBuffer(0L, 0);

    public void wrapString(String string) {
        this.bytes.wrap(string.getBytes());
    }

    public void wrapBuffer(DirectBuffer buffer) {
        this.bytes.wrap(buffer);
    }

    public void wrap(DirectBuffer directBuffer, int offset, int length) {
        int stringLen = directBuffer.getInt(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        byte[] b = new byte[stringLen];
        directBuffer.getBytes(offset += 4, b);
        this.bytes.wrap(b);
    }

    public int getLength() {
        return 4 + this.bytes.capacity();
    }

    public void write(MutableDirectBuffer mutableDirectBuffer, int offset) {
        int length = this.bytes.capacity();
        mutableDirectBuffer.putInt(offset, length, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        mutableDirectBuffer.putBytes(offset += 4, this.bytes, 0, this.bytes.capacity());
    }

    public String toString() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bytes);
    }

    public DirectBuffer getBuffer() {
        return this.bytes;
    }
}

