/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl.rocksdb;

import io.zeebe.db.ZeebeDbFactory;
import io.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionPriority;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public final class ZeebeRocksDbFactory<ColumnFamilyType extends Enum<ColumnFamilyType>>
implements ZeebeDbFactory<ColumnFamilyType> {
    private final Class<ColumnFamilyType> columnFamilyTypeClass;

    private ZeebeRocksDbFactory(Class<ColumnFamilyType> columnFamilyTypeClass) {
        this.columnFamilyTypeClass = columnFamilyTypeClass;
    }

    public static <ColumnFamilyType extends Enum<ColumnFamilyType>> ZeebeDbFactory<ColumnFamilyType> newFactory(Class<ColumnFamilyType> columnFamilyTypeClass) {
        return new ZeebeRocksDbFactory<ColumnFamilyType>(columnFamilyTypeClass);
    }

    @Override
    public ZeebeTransactionDb<ColumnFamilyType> createDb(File pathName) {
        return this.open(pathName, Arrays.stream(this.columnFamilyTypeClass.getEnumConstants()).map(c -> c.name().toLowerCase().getBytes()).collect(Collectors.toList()));
    }

    protected ZeebeTransactionDb<ColumnFamilyType> open(File dbDirectory, List<byte[]> columnFamilyNames) {
        ZeebeTransactionDb<ColumnFamilyType> db;
        try {
            ArrayList<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
            ColumnFamilyOptions columnFamilyOptions = ZeebeRocksDbFactory.createColumnFamilyOptions();
            closeables.add((AutoCloseable)columnFamilyOptions);
            List<ColumnFamilyDescriptor> columnFamilyDescriptors = this.createFamilyDescriptors(columnFamilyNames, columnFamilyOptions);
            DBOptions dbOptions = new DBOptions().setCreateMissingColumnFamilies(true).setErrorIfExists(false).setCreateIfMissing(true).setParanoidChecks(true);
            closeables.add((AutoCloseable)dbOptions);
            db = ZeebeTransactionDb.openTransactionalDb(dbOptions, dbDirectory.getAbsolutePath(), columnFamilyDescriptors, closeables, this.columnFamilyTypeClass);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("Unexpected error occurred trying to open the database", e);
        }
        return db;
    }

    private List<ColumnFamilyDescriptor> createFamilyDescriptors(List<byte[]> columnFamilyNames, ColumnFamilyOptions columnFamilyOptions) {
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        if (columnFamilyNames != null && columnFamilyNames.size() > 0) {
            for (byte[] name : columnFamilyNames) {
                ColumnFamilyDescriptor columnFamilyDescriptor = new ColumnFamilyDescriptor(name, columnFamilyOptions);
                columnFamilyDescriptors.add(columnFamilyDescriptor);
            }
        }
        return columnFamilyDescriptors;
    }

    private static ColumnFamilyOptions createColumnFamilyOptions() {
        return new ColumnFamilyOptions().setCompactionPriority(CompactionPriority.OldestSmallestSeqFirst);
    }

    static {
        RocksDB.loadLibrary();
    }
}

