/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl.rocksdb.transaction;

import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionOperation;
import io.zeebe.db.ZeebeDbException;
import io.zeebe.db.ZeebeDbTransaction;
import io.zeebe.db.impl.rocksdb.transaction.RocksDbInternal;
import io.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.zeebe.util.exception.RecoverableException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Status;

public class DefaultDbContext
implements DbContext {
    private static final byte[] ZERO_SIZE_ARRAY = new byte[0];
    private final ZeebeTransaction transaction;
    private final ExpandableArrayBuffer keyBuffer = new ExpandableArrayBuffer();
    private final ExpandableArrayBuffer valueBuffer = new ExpandableArrayBuffer();
    private final DirectBuffer keyViewBuffer = new UnsafeBuffer(0L, 0);
    private final DirectBuffer valueViewBuffer = new UnsafeBuffer(0L, 0);
    private final Queue<ExpandableArrayBuffer> prefixKeyBuffers;

    DefaultDbContext(ZeebeTransaction transaction) {
        this.transaction = transaction;
        this.prefixKeyBuffers = new ArrayDeque<ExpandableArrayBuffer>();
        this.prefixKeyBuffers.add(new ExpandableArrayBuffer());
        this.prefixKeyBuffers.add(new ExpandableArrayBuffer());
    }

    @Override
    public void writeKey(DbKey key) {
        key.write((MutableDirectBuffer)this.keyBuffer, 0);
    }

    @Override
    public void writeValue(DbValue value) {
        value.write((MutableDirectBuffer)this.valueBuffer, 0);
    }

    @Override
    public byte[] getKeyBufferArray() {
        return this.keyBuffer.byteArray();
    }

    @Override
    public byte[] getValueBufferArray() {
        return this.valueBuffer.byteArray();
    }

    @Override
    public void wrapKeyView(byte[] key) {
        if (key != null) {
            this.keyViewBuffer.wrap(key);
        } else {
            this.keyViewBuffer.wrap(ZERO_SIZE_ARRAY);
        }
    }

    @Override
    public DirectBuffer getKeyView() {
        return this.isKeyViewEmpty() ? null : this.keyViewBuffer;
    }

    @Override
    public boolean isKeyViewEmpty() {
        return this.keyViewBuffer.capacity() == ZERO_SIZE_ARRAY.length;
    }

    @Override
    public void wrapValueView(byte[] value) {
        if (value != null) {
            this.valueViewBuffer.wrap(value);
        } else {
            this.valueViewBuffer.wrap(ZERO_SIZE_ARRAY);
        }
    }

    @Override
    public DirectBuffer getValueView() {
        return this.isValueViewEmpty() ? null : this.valueViewBuffer;
    }

    @Override
    public boolean isValueViewEmpty() {
        return this.valueViewBuffer.capacity() == ZERO_SIZE_ARRAY.length;
    }

    @Override
    public void withPrefixKeyBuffer(Consumer<ExpandableArrayBuffer> prefixKeyBufferConsumer) {
        if (this.prefixKeyBuffers.peek() == null) {
            throw new IllegalStateException("Currently nested prefix iterations are not supported! This will cause unexpected behavior.");
        }
        ExpandableArrayBuffer prefixKeyBuffer = this.prefixKeyBuffers.remove();
        try {
            prefixKeyBufferConsumer.accept(prefixKeyBuffer);
        }
        finally {
            this.prefixKeyBuffers.add(prefixKeyBuffer);
        }
    }

    @Override
    public RocksIterator newIterator(ReadOptions options, ColumnFamilyHandle handle) {
        return this.transaction.newIterator(options, handle);
    }

    @Override
    public void runInTransaction(TransactionOperation operations) {
        try {
            if (this.transaction.isInCurrentTransaction()) {
                operations.run();
            } else {
                this.runInNewTransaction(operations);
            }
        }
        catch (RecoverableException recoverableException) {
            throw recoverableException;
        }
        catch (RocksDBException rdbex) {
            String errorMessage = "Unexpected error occurred during RocksDB transaction.";
            if (this.isRocksDbExceptionRecoverable(rdbex)) {
                throw new ZeebeDbException("Unexpected error occurred during RocksDB transaction.", rdbex);
            }
            throw new RuntimeException("Unexpected error occurred during RocksDB transaction.", rdbex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected error occurred during zeebe db transaction operation.", ex);
        }
    }

    @Override
    public ZeebeDbTransaction getCurrentTransaction() {
        if (!this.transaction.isInCurrentTransaction()) {
            this.transaction.resetTransaction();
        }
        return this.transaction;
    }

    private void runInNewTransaction(TransactionOperation operations) throws Exception {
        try {
            this.transaction.resetTransaction();
            operations.run();
            this.transaction.commitInternal();
        }
        finally {
            this.transaction.rollbackInternal();
        }
    }

    private boolean isRocksDbExceptionRecoverable(RocksDBException rdbex) {
        Status status = rdbex.getStatus();
        return RocksDbInternal.RECOVERABLE_ERROR_CODES.contains(status.getCode());
    }
}

