/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl.rocksdb.transaction;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.KeyValuePairVisitor;
import io.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

class TransactionalColumnFamily<ColumnFamilyNames extends Enum<ColumnFamilyNames>, KeyType extends DbKey, ValueType extends DbValue>
implements ColumnFamily<KeyType, ValueType> {
    private final ZeebeTransactionDb<ColumnFamilyNames> transactionDb;
    private final long handle;
    private final DbContext context;
    private final ValueType valueInstance;
    private final KeyType keyInstance;

    TransactionalColumnFamily(ZeebeTransactionDb<ColumnFamilyNames> transactionDb, ColumnFamilyNames columnFamily, DbContext context, KeyType keyInstance, ValueType valueInstance) {
        this.transactionDb = transactionDb;
        this.handle = this.transactionDb.getColumnFamilyHandle(columnFamily);
        this.context = context;
        this.keyInstance = keyInstance;
        this.valueInstance = valueInstance;
    }

    @Override
    public void put(KeyType key, ValueType value) {
        this.put(this.context, key, value);
    }

    @Override
    public void put(DbContext context, KeyType key, ValueType value) {
        this.transactionDb.put(this.handle, context, (DbKey)key, (DbValue)value);
    }

    @Override
    public ValueType get(KeyType key) {
        return this.get(this.context, key);
    }

    public ValueType get(DbContext context, KeyType key) {
        return this.get(context, key, this.valueInstance);
    }

    @Override
    public ValueType get(DbContext context, KeyType key, ValueType value) {
        DirectBuffer valueBuffer = this.transactionDb.get(this.handle, context, (DbKey)key);
        if (valueBuffer != null) {
            value.wrap(valueBuffer, 0, valueBuffer.capacity());
            return value;
        }
        return null;
    }

    @Override
    public void forEach(Consumer<ValueType> consumer) {
        this.forEach(this.context, consumer);
    }

    public void forEach(DbContext context, Consumer<ValueType> consumer) {
        this.transactionDb.foreach(this.handle, context, this.valueInstance, consumer);
    }

    @Override
    public void forEach(BiConsumer<KeyType, ValueType> consumer) {
        this.forEach(this.context, consumer);
    }

    public void forEach(DbContext context, BiConsumer<KeyType, ValueType> consumer) {
        this.transactionDb.foreach(this.handle, context, this.keyInstance, this.valueInstance, consumer);
    }

    @Override
    public void whileTrue(KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileTrue(this.context, visitor);
    }

    public void whileTrue(DbContext context, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileTrue(context, visitor, this.keyInstance, this.valueInstance);
    }

    @Override
    public void whileTrue(DbContext context, KeyValuePairVisitor<KeyType, ValueType> visitor, KeyType key, ValueType value) {
        this.transactionDb.whileTrue(this.handle, context, key, value, visitor);
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, keyPrefix, visitor);
    }

    public void whileEqualPrefix(DbContext context, DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.transactionDb.whileEqualPrefix(this.handle, context, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, keyPrefix, visitor);
    }

    public void whileEqualPrefix(DbContext context, DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.transactionDb.whileEqualPrefix(this.handle, context, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    @Override
    public void delete(KeyType key) {
        this.delete(this.context, key);
    }

    @Override
    public void delete(DbContext context, KeyType key) {
        this.transactionDb.delete(this.handle, context, (DbKey)key);
    }

    @Override
    public boolean exists(KeyType key) {
        return this.exists(this.context, key);
    }

    public boolean exists(DbContext context, KeyType key) {
        return this.transactionDb.exists(this.handle, context, (DbKey)key);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(this.context);
    }

    @Override
    public boolean isEmpty(DbContext context) {
        return this.transactionDb.isEmpty(this.handle, context);
    }
}

