/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl.rocksdb.transaction;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.KeyValuePairVisitor;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.ZeebeDbException;
import io.zeebe.db.impl.rocksdb.Loggers;
import io.zeebe.db.impl.rocksdb.transaction.DefaultDbContext;
import io.zeebe.db.impl.rocksdb.transaction.RocksDbInternal;
import io.zeebe.db.impl.rocksdb.transaction.TransactionalColumnFamily;
import io.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.zeebe.util.buffer.BufferUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.OptimisticTransactionDB;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.Transaction;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

public class ZeebeTransactionDb<ColumnFamilyNames extends Enum<ColumnFamilyNames>>
implements ZeebeDb<ColumnFamilyNames> {
    private static final Logger LOG = Loggers.DB_LOGGER;
    private static final String ERROR_MESSAGE_CLOSE_RESOURCE = "Expected to close RocksDB resource successfully, but exception was thrown. Will continue to close remaining resources.";
    private final OptimisticTransactionDB optimisticTransactionDB;
    private final List<AutoCloseable> closables;
    private final EnumMap<ColumnFamilyNames, Long> columnFamilyMap;
    private final Long2ObjectHashMap<ColumnFamilyHandle> handelToEnumMap;
    private final ReadOptions prefixReadOptions;
    private final ReadOptions defaultReadOptions;
    private final WriteOptions defaultWriteOptions;

    public static <ColumnFamilyNames extends Enum<ColumnFamilyNames>> ZeebeTransactionDb<ColumnFamilyNames> openTransactionalDb(DBOptions options, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<AutoCloseable> closables, Class<ColumnFamilyNames> columnFamilyTypeClass) throws RocksDBException {
        EnumMap<ColumnFamilyNames, Long> columnFamilyMap = new EnumMap<ColumnFamilyNames, Long>(columnFamilyTypeClass);
        ArrayList handles = new ArrayList();
        OptimisticTransactionDB optimisticTransactionDB = OptimisticTransactionDB.open((DBOptions)options, (String)path, columnFamilyDescriptors, handles);
        closables.add((AutoCloseable)optimisticTransactionDB);
        Enum[] enumConstants = (Enum[])columnFamilyTypeClass.getEnumConstants();
        Long2ObjectHashMap handleToEnumMap = new Long2ObjectHashMap();
        for (int i = 0; i < handles.size(); ++i) {
            ColumnFamilyHandle columnFamilyHandle = (ColumnFamilyHandle)handles.get(i);
            closables.add((AutoCloseable)columnFamilyHandle);
            columnFamilyMap.put(enumConstants[i], ZeebeTransactionDb.getNativeHandle((RocksObject)columnFamilyHandle));
            handleToEnumMap.put(ZeebeTransactionDb.getNativeHandle((RocksObject)handles.get(i)), handles.get(i));
        }
        return new ZeebeTransactionDb<ColumnFamilyNames>(optimisticTransactionDB, columnFamilyMap, (Long2ObjectHashMap<ColumnFamilyHandle>)handleToEnumMap, closables);
    }

    private static long getNativeHandle(RocksObject object) {
        try {
            return RocksDbInternal.nativeHandle.getLong(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unexpected error occurred trying to access private nativeHandle_ field", e);
        }
    }

    protected ZeebeTransactionDb(OptimisticTransactionDB optimisticTransactionDB, EnumMap<ColumnFamilyNames, Long> columnFamilyMap, Long2ObjectHashMap<ColumnFamilyHandle> handelToEnumMap, List<AutoCloseable> closables) {
        this.optimisticTransactionDB = optimisticTransactionDB;
        this.columnFamilyMap = columnFamilyMap;
        this.handelToEnumMap = handelToEnumMap;
        this.closables = closables;
        this.prefixReadOptions = new ReadOptions().setPrefixSameAsStart(true).setTotalOrderSeek(false);
        closables.add((AutoCloseable)this.prefixReadOptions);
        this.defaultReadOptions = new ReadOptions();
        closables.add((AutoCloseable)this.defaultReadOptions);
        this.defaultWriteOptions = new WriteOptions();
        closables.add((AutoCloseable)this.defaultWriteOptions);
    }

    long getColumnFamilyHandle(ColumnFamilyNames columnFamily) {
        return this.columnFamilyMap.get(columnFamily);
    }

    @Override
    public <KeyType extends DbKey, ValueType extends DbValue> ColumnFamily<KeyType, ValueType> createColumnFamily(ColumnFamilyNames columnFamily, DbContext context, KeyType keyInstance, ValueType valueInstance) {
        return new TransactionalColumnFamily<ColumnFamilyNames, KeyType, ValueType>(this, columnFamily, context, keyInstance, valueInstance);
    }

    protected void put(long columnFamilyHandle, DbContext context, DbKey key, DbValue value) {
        this.ensureInOpenTransaction(context, transaction -> {
            context.writeKey(key);
            context.writeValue(value);
            transaction.put(columnFamilyHandle, context.getKeyBufferArray(), key.getLength(), context.getValueBufferArray(), value.getLength());
        });
    }

    private void ensureInOpenTransaction(DbContext context, TransactionConsumer operation) {
        context.runInTransaction(() -> operation.run((ZeebeTransaction)context.getCurrentTransaction()));
    }

    protected DirectBuffer get(long columnFamilyHandle, DbContext context, DbKey key) {
        context.writeKey(key);
        int keyLength = key.getLength();
        return this.getValue(columnFamilyHandle, context, keyLength);
    }

    private DirectBuffer getValue(long columnFamilyHandle, DbContext context, int keyLength) {
        this.ensureInOpenTransaction(context, transaction -> {
            byte[] value = transaction.get(columnFamilyHandle, ZeebeTransactionDb.getNativeHandle((RocksObject)this.defaultReadOptions), context.getKeyBufferArray(), keyLength);
            context.wrapValueView(value);
        });
        return context.getValueView();
    }

    protected boolean exists(long columnFamilyHandle, DbContext context, DbKey key) {
        context.wrapValueView(new byte[0]);
        this.ensureInOpenTransaction(context, transaction -> {
            context.writeKey(key);
            this.getValue(columnFamilyHandle, context, key.getLength());
        });
        return !context.isValueViewEmpty();
    }

    protected void delete(long columnFamilyHandle, DbContext context, DbKey key) {
        context.writeKey(key);
        this.ensureInOpenTransaction(context, transaction -> transaction.delete(columnFamilyHandle, context.getKeyBufferArray(), key.getLength()));
    }

    RocksIterator newIterator(long columnFamilyHandle, DbContext context, ReadOptions options) {
        ColumnFamilyHandle handle = (ColumnFamilyHandle)this.handelToEnumMap.get(columnFamilyHandle);
        return context.newIterator(options, handle);
    }

    public <ValueType extends DbValue> void foreach(long columnFamilyHandle, DbContext context, ValueType iteratorValue, Consumer<ValueType> consumer) {
        this.foreach(columnFamilyHandle, context, (keyBuffer, valueBuffer) -> {
            iteratorValue.wrap((DirectBuffer)valueBuffer, 0, valueBuffer.capacity());
            consumer.accept(iteratorValue);
        });
    }

    public <KeyType extends DbKey, ValueType extends DbValue> void foreach(long columnFamilyHandle, DbContext context, KeyType iteratorKey, ValueType iteratorValue, BiConsumer<KeyType, ValueType> consumer) {
        this.foreach(columnFamilyHandle, context, (keyBuffer, valueBuffer) -> {
            iteratorKey.wrap((DirectBuffer)keyBuffer, 0, keyBuffer.capacity());
            iteratorValue.wrap((DirectBuffer)valueBuffer, 0, valueBuffer.capacity());
            consumer.accept(iteratorKey, iteratorValue);
        });
    }

    private void foreach(long columnFamilyHandle, DbContext context, BiConsumer<DirectBuffer, DirectBuffer> keyValuePairConsumer) {
        this.ensureInOpenTransaction(context, transaction -> {
            try (RocksIterator iterator = this.newIterator(columnFamilyHandle, context, this.defaultReadOptions);){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    context.wrapKeyView(iterator.key());
                    context.wrapValueView(iterator.value());
                    keyValuePairConsumer.accept(context.getKeyView(), context.getValueView());
                    iterator.next();
                }
            }
        });
    }

    public <KeyType extends DbKey, ValueType extends DbValue> void whileTrue(long columnFamilyHandle, DbContext context, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(context, transaction -> {
            try (RocksIterator iterator = this.newIterator(columnFamilyHandle, context, this.defaultReadOptions);){
                boolean shouldVisitNext = true;
                iterator.seekToFirst();
                while (iterator.isValid() && shouldVisitNext) {
                    shouldVisitNext = this.visit(context, keyInstance, valueInstance, visitor, iterator);
                    iterator.next();
                }
            }
        });
    }

    protected <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(long columnFamilyHandle, DbContext context, DbKey prefix, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(columnFamilyHandle, context, prefix, keyInstance, valueInstance, (KeyType k, ValueType v) -> {
            visitor.accept(k, v);
            return true;
        });
    }

    protected <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(long columnFamilyHandle, DbContext context, DbKey prefix, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        context.withPrefixKeyBuffer(prefixKeyBuffer -> this.ensureInOpenTransaction(context, transaction -> {
            try (RocksIterator iterator = this.newIterator(columnFamilyHandle, context, this.prefixReadOptions);){
                prefix.write((MutableDirectBuffer)prefixKeyBuffer, 0);
                int prefixLength = prefix.getLength();
                boolean shouldVisitNext = true;
                RocksDbInternal.seek(iterator, ZeebeTransactionDb.getNativeHandle((RocksObject)iterator), prefixKeyBuffer.byteArray(), prefixLength);
                while (iterator.isValid() && shouldVisitNext) {
                    byte[] keyBytes = iterator.key();
                    if (!BufferUtil.startsWith((byte[])prefixKeyBuffer.byteArray(), (int)0, (int)prefix.getLength(), (byte[])keyBytes, (int)0, (int)keyBytes.length)) {
                        break;
                    }
                    shouldVisitNext = this.visit(context, keyInstance, valueInstance, visitor, iterator);
                    iterator.next();
                }
            }
        }));
    }

    private <KeyType extends DbKey, ValueType extends DbValue> boolean visit(DbContext context, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> iteratorConsumer, RocksIterator iterator) {
        context.wrapKeyView(iterator.key());
        context.wrapValueView(iterator.value());
        DirectBuffer keyViewBuffer = context.getKeyView();
        keyInstance.wrap(keyViewBuffer, 0, keyViewBuffer.capacity());
        DirectBuffer valueViewBuffer = context.getValueView();
        valueInstance.wrap(valueViewBuffer, 0, valueViewBuffer.capacity());
        return iteratorConsumer.visit(keyInstance, valueInstance);
    }

    public boolean isEmpty(long columnFamilyHandle, DbContext context) {
        AtomicBoolean isEmpty = new AtomicBoolean(false);
        this.ensureInOpenTransaction(context, transaction -> {
            try (RocksIterator iterator = this.newIterator(columnFamilyHandle, context, this.defaultReadOptions);){
                iterator.seekToFirst();
                boolean hasEntry = iterator.isValid();
                isEmpty.set(!hasEntry);
            }
        });
        return isEmpty.get();
    }

    @Override
    public void createSnapshot(File snapshotDir) {
        try (Checkpoint checkpoint = Checkpoint.create((RocksDB)this.optimisticTransactionDB);){
            try {
                checkpoint.createCheckpoint(snapshotDir.getAbsolutePath());
            }
            catch (RocksDBException rocksException) {
                throw new ZeebeDbException(rocksException);
            }
        }
    }

    @Override
    public DbContext createContext() {
        Transaction transaction = this.optimisticTransactionDB.beginTransaction(this.defaultWriteOptions);
        ZeebeTransaction zeebeTransaction = new ZeebeTransaction(transaction);
        this.closables.add(zeebeTransaction);
        return new DefaultDbContext(zeebeTransaction);
    }

    @Override
    public void close() {
        Collections.reverse(this.closables);
        this.closables.forEach(closable -> {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_CLOSE_RESOURCE, (Throwable)e);
            }
        });
    }

    @FunctionalInterface
    static interface TransactionConsumer {
        public void run(ZeebeTransaction var1) throws Exception;
    }
}

