/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.MemberGroupId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElectionEvent;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.primitive.partition.impl.PrimaryElectorEvents;
import io.atomix.primitive.partition.impl.PrimaryElectorOperations;
import io.atomix.primitive.partition.impl.PrimaryElectorType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.primitive.session.Session;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PrimaryElectorService
extends AbstractPrimitiveService {
    private static final Duration REBALANCE_DURATION = Duration.ofSeconds(15L);
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(PrimaryElectorOperations.NAMESPACE).register(PrimaryElectorEvents.NAMESPACE).register(new Class[]{ElectionState.class}).register(new Class[]{Registration.class}).register(new Class[]{new LinkedHashMap().keySet().getClass()}).build());
    private Map<PartitionId, ElectionState> elections = new HashMap<PartitionId, ElectionState>();
    private Map<Long, Session> listeners = new LinkedHashMap<Long, Session>();
    private Scheduled rebalanceTimer;

    public PrimaryElectorService() {
        super(PrimaryElectorType.instance());
    }

    @Override
    public Serializer serializer() {
        return SERIALIZER;
    }

    @Override
    public void backup(BackupOutput writer) {
        writer.writeObject(Sets.newHashSet(this.listeners.keySet()), arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
        writer.writeObject(this.elections, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
        this.getLogger().debug("Took state machine snapshot");
    }

    @Override
    public void restore(BackupInput reader) {
        this.listeners = new LinkedHashMap<Long, Session>();
        for (Long sessionId : (Set)reader.readObject(arg_0 -> ((Serializer)SERIALIZER).decode(arg_0))) {
            this.listeners.put(sessionId, this.getSession(sessionId));
        }
        this.elections = (Map)reader.readObject(arg_0 -> ((Serializer)SERIALIZER).decode(arg_0));
        this.elections.values().forEach(e -> ((ElectionState)e).elections = this.elections);
        this.getLogger().debug("Reinstated state machine from snapshot");
    }

    @Override
    protected void configure(ServiceExecutor executor) {
        executor.register((OperationId)PrimaryElectorOperations.ENTER, this::enter);
        executor.register((OperationId)PrimaryElectorOperations.GET_TERM, this::getTerm);
    }

    private void notifyTermChange(PartitionId partitionId, PrimaryTerm term) {
        this.listeners.values().forEach(session -> session.publish(PrimaryElectorEvents.CHANGE, new PrimaryElectionEvent(PrimaryElectionEvent.Type.CHANGED, partitionId, term)));
    }

    private void scheduleRebalance() {
        if (this.rebalanceTimer != null) {
            this.rebalanceTimer.cancel();
        }
        this.rebalanceTimer = this.getScheduler().schedule(REBALANCE_DURATION, this::rebalance);
    }

    private void rebalance() {
        boolean rebalanced = false;
        for (ElectionState election : this.elections.values()) {
            int primaryCount = election.countPrimaries(election.primary);
            int minCandidateCount = 0;
            for (Registration candidate : election.registrations) {
                if (minCandidateCount == 0) {
                    minCandidateCount = election.countPrimaries(candidate);
                    continue;
                }
                minCandidateCount = Math.min(minCandidateCount, election.countPrimaries(candidate));
            }
            if (minCandidateCount >= primaryCount) continue;
            for (Registration candidate : election.registrations) {
                if (election.countPrimaries(candidate) >= primaryCount) continue;
                PrimaryTerm oldTerm = election.term();
                this.elections.put(election.partitionId, election.transfer(candidate.member()));
                PrimaryTerm newTerm = this.term(election.partitionId);
                if (Objects.equals(oldTerm, newTerm)) continue;
                this.notifyTermChange(election.partitionId, newTerm);
                rebalanced = true;
            }
        }
        if (rebalanced) {
            this.scheduleRebalance();
        }
    }

    protected PrimaryTerm enter(Commit<? extends PrimaryElectorOperations.Enter> commit) {
        try {
            PartitionId partitionId = commit.value().partitionId();
            PrimaryTerm oldTerm = this.term(partitionId);
            Registration registration = new Registration(commit.value().member(), (Long)commit.session().sessionId().id());
            PrimaryTerm newTerm = this.elections.compute(partitionId, (k, v) -> {
                if (v == null) {
                    return new ElectionState(partitionId, registration, this.elections);
                }
                if (!v.isDuplicate(registration)) {
                    return new ElectionState((ElectionState)v).addRegistration(registration);
                }
                return v;
            }).term();
            if (!Objects.equals(oldTerm, newTerm)) {
                this.notifyTermChange(partitionId, newTerm);
                this.scheduleRebalance();
            }
            return newTerm;
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected PrimaryTerm getTerm(Commit<? extends PrimaryElectorOperations.GetTerm> commit) {
        PartitionId partitionId = commit.value().partitionId();
        try {
            return this.term(partitionId);
        }
        catch (Exception e) {
            this.getLogger().error("State machine operation failed", (Throwable)e);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private PrimaryTerm term(PartitionId partitionId) {
        ElectionState electionState = this.elections.get(partitionId);
        return electionState != null ? electionState.term() : null;
    }

    private void onSessionEnd(Session session) {
        this.listeners.remove(session.sessionId().id());
        Set<PartitionId> partitions = this.elections.keySet();
        partitions.forEach(partitionId -> {
            PrimaryTerm oldTerm = this.term((PartitionId)partitionId);
            this.elections.compute((PartitionId)partitionId, (k, v) -> v.cleanup(session));
            PrimaryTerm newTerm = this.term((PartitionId)partitionId);
            if (!Objects.equals(oldTerm, newTerm)) {
                this.notifyTermChange((PartitionId)partitionId, newTerm);
                this.scheduleRebalance();
            }
        });
    }

    @Override
    public void onOpen(Session session) {
        this.listeners.put((Long)session.sessionId().id(), session);
    }

    @Override
    public void onExpire(Session session) {
        this.onSessionEnd(session);
    }

    @Override
    public void onClose(Session session) {
        this.onSessionEnd(session);
    }

    private static class ElectionState {
        private final PartitionId partitionId;
        private final Registration primary;
        private final long term;
        private final long termStartTime;
        private final List<Registration> registrations;
        private transient Map<PartitionId, ElectionState> elections;

        ElectionState(PartitionId partitionId, Registration registration, Map<PartitionId, ElectionState> elections) {
            this.registrations = Arrays.asList(registration);
            this.termStartTime = System.currentTimeMillis();
            this.primary = registration;
            this.partitionId = partitionId;
            this.term = 1L;
            this.elections = elections;
        }

        ElectionState(ElectionState other) {
            this.partitionId = other.partitionId;
            this.registrations = Lists.newArrayList(other.registrations);
            this.primary = other.primary;
            this.term = other.term;
            this.termStartTime = other.termStartTime;
            this.elections = other.elections;
        }

        ElectionState(PartitionId partitionId, List<Registration> registrations, Registration primary, long term, long termStartTime, Map<PartitionId, ElectionState> elections) {
            this.partitionId = partitionId;
            this.registrations = Lists.newArrayList(registrations);
            this.primary = primary;
            this.term = term;
            this.termStartTime = termStartTime;
            this.elections = elections;
        }

        ElectionState cleanup(Session session) {
            Optional<Registration> registration = this.registrations.stream().filter(r -> r.sessionId() == ((Long)session.sessionId().id()).longValue()).findFirst();
            if (registration.isPresent()) {
                List<Registration> updatedRegistrations = this.registrations.stream().filter(r -> r.sessionId() != ((Long)session.sessionId().id()).longValue()).collect(Collectors.toList());
                if (this.primary.sessionId() == ((Long)session.sessionId().id()).longValue()) {
                    if (!updatedRegistrations.isEmpty()) {
                        return new ElectionState(this.partitionId, updatedRegistrations, (Registration)updatedRegistrations.get(0), this.term + 1L, System.currentTimeMillis(), this.elections);
                    }
                    return new ElectionState(this.partitionId, updatedRegistrations, null, this.term, this.termStartTime, this.elections);
                }
                return new ElectionState(this.partitionId, updatedRegistrations, this.primary, this.term, this.termStartTime, this.elections);
            }
            return this;
        }

        boolean isDuplicate(Registration registration) {
            return this.registrations.stream().anyMatch(r -> r.sessionId() == registration.sessionId());
        }

        PrimaryTerm term() {
            return new PrimaryTerm(this.term, this.primary(), this.candidates());
        }

        GroupMember primary() {
            if (this.primary == null) {
                return null;
            }
            return this.primary.member();
        }

        List<GroupMember> candidates() {
            return this.registrations.stream().map(registration -> registration.member()).collect(Collectors.toList());
        }

        ElectionState addRegistration(Registration registration) {
            if (!this.registrations.stream().anyMatch(r -> r.sessionId() == registration.sessionId())) {
                LinkedList<Registration> updatedRegistrations = new LinkedList<Registration>(this.registrations);
                boolean added = false;
                int registrationCount = this.countPrimaries(registration);
                for (int i = 0; i < this.registrations.size(); ++i) {
                    if (this.countPrimaries(this.registrations.get(i)) <= registrationCount) continue;
                    updatedRegistrations.add(i, registration);
                    added = true;
                    break;
                }
                if (!added) {
                    updatedRegistrations.add(registration);
                }
                List<Registration> sortedRegistrations = this.sortRegistrations(updatedRegistrations);
                Registration firstRegistration = sortedRegistrations.get(0);
                Registration leader = this.primary;
                long term = this.term;
                long termStartTime = this.termStartTime;
                if (leader == null || !leader.equals(firstRegistration)) {
                    leader = firstRegistration;
                    term = this.term + 1L;
                    termStartTime = System.currentTimeMillis();
                }
                return new ElectionState(this.partitionId, sortedRegistrations, leader, term, termStartTime, this.elections);
            }
            return this;
        }

        List<Registration> sortRegistrations(List<Registration> registrations) {
            int groupCount = (int)registrations.stream().map(r -> r.member().groupId()).distinct().count();
            HashSet<MemberGroupId> groups = new HashSet<MemberGroupId>();
            LinkedList<Registration> sortedRegistrations = new LinkedList<Registration>();
            while (!registrations.isEmpty()) {
                groups.clear();
                Iterator<Registration> iterator = registrations.iterator();
                while (iterator.hasNext()) {
                    Registration registration = iterator.next();
                    if (!groups.add(registration.member().groupId())) continue;
                    sortedRegistrations.add(registration);
                    iterator.remove();
                    if (groups.size() != groupCount) continue;
                    groups.clear();
                }
            }
            return sortedRegistrations;
        }

        int countPrimaries(Registration registration) {
            if (registration == null) {
                return 0;
            }
            return (int)this.elections.entrySet().stream().filter(entry -> !((PartitionId)entry.getKey()).equals(this.partitionId)).filter(entry -> ((ElectionState)entry.getValue()).primary != null).filter(entry -> {
                GroupMember leaderId = ((ElectionState)entry.getValue()).primary();
                List sessionCandidates = ((ElectionState)entry.getValue()).registrations.stream().filter(r -> ((Registration)r).sessionId == registration.sessionId).map(r -> r.member()).collect(Collectors.toList());
                return sessionCandidates.stream().anyMatch(candidate -> Objects.equals(candidate, leaderId));
            }).count();
        }

        ElectionState transfer(GroupMember member) {
            Registration newLeader = this.registrations.stream().filter(r -> Objects.equals(r.member(), member)).findFirst().orElse(null);
            if (newLeader != null) {
                return new ElectionState(this.partitionId, this.registrations, newLeader, this.term + 1L, System.currentTimeMillis(), this.elections);
            }
            return this;
        }
    }

    private static class Registration {
        private final GroupMember member;
        private final long sessionId;

        Registration(GroupMember member, long sessionId) {
            this.member = member;
            this.sessionId = sessionId;
        }

        public GroupMember member() {
            return this.member;
        }

        public long sessionId() {
            return this.sessionId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("member", (Object)this.member).add("session", this.sessionId).toString();
        }
    }
}

