/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.OrderedFuture;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class RecoveringSessionClient
implements SessionClient {
    private static final SessionId DEFAULT_SESSION_ID = SessionId.from(0L);
    private final PartitionId partitionId;
    private final String name;
    private final PrimitiveType primitiveType;
    private final Supplier<CompletableFuture<SessionClient>> proxyFactory;
    private final ThreadContext context;
    private Logger log;
    private volatile CompletableFuture<SessionClient> connectFuture;
    private volatile CompletableFuture<Void> closeFuture;
    private volatile SessionClient session;
    private volatile PrimitiveState state = PrimitiveState.CLOSED;
    private final Set<Consumer<PrimitiveState>> stateChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Multimap<EventType, Consumer<PrimitiveEvent>> eventListeners = HashMultimap.create();
    private Scheduled recoverTask;
    private volatile boolean connected;

    public RecoveringSessionClient(String clientId, PartitionId partitionId, String name, PrimitiveType primitiveType, Supplier<CompletableFuture<SessionClient>> sessionFactory, ThreadContext context) {
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType);
        this.proxyFactory = (Supplier)Preconditions.checkNotNull(sessionFactory);
        this.context = (ThreadContext)Preconditions.checkNotNull((Object)context);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(SessionClient.class).addValue((Object)clientId).build());
    }

    @Override
    public SessionId sessionId() {
        SessionClient proxy = this.session;
        return proxy != null ? proxy.sessionId() : DEFAULT_SESSION_ID;
    }

    @Override
    public PartitionId partitionId() {
        return this.partitionId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public PrimitiveType type() {
        return this.primitiveType;
    }

    @Override
    public ThreadContext context() {
        return this.context;
    }

    @Override
    public PrimitiveState getState() {
        return this.state;
    }

    private synchronized void onStateChange(PrimitiveState state) {
        if (this.state != state) {
            if (state == PrimitiveState.EXPIRED) {
                if (this.connected) {
                    this.onStateChange(PrimitiveState.SUSPENDED);
                    this.recover();
                } else {
                    this.log.debug("State changed: {}", (Object)state);
                    this.state = state;
                    this.stateChangeListeners.forEach(l -> l.accept(state));
                }
            } else {
                this.log.debug("State changed: {}", (Object)state);
                this.state = state;
                this.stateChangeListeners.forEach(l -> l.accept(state));
                if (state == PrimitiveState.CLOSED) {
                    this.connectFuture = Futures.exceptionalFuture((Throwable)((Object)new PrimitiveException.ClosedSession()));
                    this.session = null;
                }
            }
        }
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.stateChangeListeners.add(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.stateChangeListeners.remove(listener);
    }

    private void recover() {
        this.session = null;
        this.connectFuture = new OrderedFuture();
        this.openProxy(this.connectFuture);
    }

    private void openProxy(CompletableFuture<SessionClient> future) {
        this.log.debug("Opening proxy session");
        ((CompletableFuture)this.proxyFactory.get().thenCompose(proxy -> proxy.connect())).whenComplete((proxy, error) -> {
            if (error == null) {
                RecoveringSessionClient recoveringSessionClient = this;
                synchronized (recoveringSessionClient) {
                    this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(SessionClient.class).addValue((Object)proxy.sessionId()).add("type", (Object)proxy.type()).add("name", (Object)proxy.name()).build());
                    this.session = proxy;
                    proxy.addStateChangeListener(this::onStateChange);
                    this.eventListeners.entries().forEach(entry -> proxy.addEventListener((EventType)entry.getKey(), (Consumer)entry.getValue()));
                    this.onStateChange(PrimitiveState.CONNECTED);
                }
                future.complete(this);
            } else {
                this.recoverTask = this.context.schedule(Duration.ofSeconds(1L), () -> this.openProxy(future));
            }
        });
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        SessionClient proxy = this.session;
        if (proxy != null) {
            return proxy.execute(operation);
        }
        return this.connectFuture.thenCompose(c -> c.execute(operation));
    }

    @Override
    public synchronized void addEventListener(EventType eventType, Consumer<PrimitiveEvent> consumer) {
        this.eventListeners.put((Object)eventType.canonicalize(), consumer);
        SessionClient proxy = this.session;
        if (proxy != null) {
            proxy.addEventListener(eventType, consumer);
        }
    }

    @Override
    public synchronized void removeEventListener(EventType eventType, Consumer<PrimitiveEvent> consumer) {
        this.eventListeners.remove((Object)eventType.canonicalize(), consumer);
        SessionClient proxy = this.session;
        if (proxy != null) {
            proxy.removeEventListener(eventType, consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<SessionClient> connect() {
        if (this.connectFuture == null) {
            RecoveringSessionClient recoveringSessionClient = this;
            synchronized (recoveringSessionClient) {
                if (this.connectFuture == null) {
                    this.connected = true;
                    this.connectFuture = new OrderedFuture();
                    this.openProxy(this.connectFuture);
                }
            }
        }
        return this.connectFuture;
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.close(SessionClient::close);
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.close(SessionClient::delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> close(Function<SessionClient, CompletableFuture<Void>> closeFunction) {
        if (this.closeFuture == null) {
            RecoveringSessionClient recoveringSessionClient = this;
            synchronized (recoveringSessionClient) {
                if (this.closeFuture == null) {
                    this.connected = false;
                    SessionClient session = this.session;
                    this.closeFuture = session != null ? closeFunction.apply(session) : (this.closeFuture != null ? this.connectFuture.thenCompose(closeFunction) : CompletableFuture.completedFuture(null));
                }
            }
        }
        return this.closeFuture;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.session.name()).add("serviceType", (Object)this.session.type()).add("state", (Object)this.state).toString();
    }
}

