/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class StorageConfiguration {
    private final File file;
    private final File tmpFile;
    private final Path path;
    private final Path tmpPath;
    private final File logDirectory;
    private final File snapshotsDirectory;
    private final File statesDirectory;
    private final File blockIndexDirectory;
    private int partitionId;
    private long logSegmentSize;
    private long indexBlockSize;

    public StorageConfiguration(File metaFile, File partitionLogDir, File partitionSnapshotsDir, File statesDir, File blockIndexDir) {
        this.logDirectory = partitionLogDir;
        this.snapshotsDirectory = partitionSnapshotsDir;
        this.statesDirectory = statesDir;
        this.blockIndexDirectory = blockIndexDir;
        this.file = metaFile;
        this.tmpFile = new File(this.file.getAbsolutePath() + ".tmp");
        this.path = Paths.get(this.file.getAbsolutePath(), new String[0]);
        this.tmpPath = Paths.get(this.file.getAbsolutePath() + ".tmp", new String[0]);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public StorageConfiguration setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public StorageConfiguration setLogSegmentSize(long value) {
        this.logSegmentSize = value;
        return this;
    }

    public long getLogSegmentSize() {
        return this.logSegmentSize;
    }

    public void setIndexBlockSize(long indexBlockSize) {
        this.indexBlockSize = indexBlockSize;
    }

    public long getIndexBlockSize() {
        return this.indexBlockSize;
    }

    public File getSnapshotsDirectory() {
        return this.snapshotsDirectory;
    }

    public File getStatesDirectory() {
        return this.statesDirectory;
    }

    public File getBlockIndexDirectory() {
        return this.blockIndexDirectory;
    }
}

